/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.parser.factory.ListenerFactory;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti.engine.impl.delegate.SubProcessActivityBehavior;
import org.activiti.engine.impl.history.handler.ActivityInstanceStartHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiInstanceActivityBehavior
extends FlowNodeActivityBehavior
implements SubProcessActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = LoggerFactory.getLogger(MultiInstanceActivityBehavior.class);
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected Activity activity;
    protected AbstractBpmnActivityBehavior innerActivityBehavior;
    protected Expression loopCardinalityExpression;
    protected Expression completionConditionExpression;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;
    protected String collectionElementIndexVariable = "loopCounter";

    public MultiInstanceActivityBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.activity = activity;
        this.setInnerActivityBehavior(innerActivityBehavior);
    }

    @Override
    public void execute(DelegateExecution execution) {
        if (this.getLocalLoopVariable(execution, this.getCollectionElementIndexVariable()) == null) {
            try {
                this.createInstances(execution);
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, execution);
            }
            if (this.resolveNrOfInstances(execution) == 0) {
                this.leave(execution);
            }
        } else {
            this.innerActivityBehavior.execute(execution);
        }
    }

    protected abstract void createInstances(DelegateExecution var1);

    protected void executeCompensationBoundaryEvents(FlowElement flowElement, DelegateExecution execution) {
        Collection<BoundaryEvent> boundaryEvents = this.findBoundaryEventsForFlowNode(execution.getProcessDefinitionId(), flowElement);
        if (CollectionUtils.isNotEmpty(boundaryEvents)) {
            for (BoundaryEvent boundaryEvent : boundaryEvents) {
                if (CollectionUtils.isEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                ExecutionEntity childExecutionEntity = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
                childExecutionEntity.setParentId(execution.getId());
                childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
                childExecutionEntity.setScope(false);
                ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
                boundaryEventBehavior.execute(childExecutionEntity);
            }
        }
    }

    protected Collection<BoundaryEvent> findBoundaryEventsForFlowNode(String processDefinitionId, FlowElement flowElement) {
        Process process = this.getProcessDefinition(processDefinitionId);
        ArrayList<BoundaryEvent> results = new ArrayList<BoundaryEvent>(1);
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (boundaryEvent.getAttachedToRefId() == null || !boundaryEvent.getAttachedToRefId().equals(flowElement.getId())) continue;
            results.add(boundaryEvent);
        }
        return results;
    }

    protected Process getProcessDefinition(String processDefinitionId) {
        return ProcessDefinitionUtil.getProcess(processDefinitionId);
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        this.innerActivityBehavior.trigger(execution, signalName, signalData);
    }

    public void lastExecutionEnded(DelegateExecution execution) {
        this.leave(execution);
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
        this.leave(execution);
    }

    protected int resolveNrOfInstances(DelegateExecution execution) {
        int nrOfInstances = -1;
        if (this.loopCardinalityExpression != null) {
            nrOfInstances = this.resolveLoopCardinality(execution);
        } else if (this.collectionExpression != null) {
            Object obj = this.collectionExpression.getValue(execution);
            if (!(obj instanceof Collection)) {
                throw new ActivitiIllegalArgumentException(this.collectionExpression.getExpressionText() + "' didn't resolve to a Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else if (this.collectionVariable != null) {
            Object obj = execution.getVariable(this.collectionVariable);
            if (obj == null) {
                throw new ActivitiIllegalArgumentException("Variable " + this.collectionVariable + " is not found");
            }
            if (!(obj instanceof Collection)) {
                throw new ActivitiIllegalArgumentException("Variable " + this.collectionVariable + "' is not a Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else {
            throw new ActivitiIllegalArgumentException("Couldn't resolve collection expression nor variable reference");
        }
        return nrOfInstances;
    }

    protected void executeOriginalBehavior(DelegateExecution execution, int loopCounter) {
        if (this.usesCollection() && this.collectionElementVariable != null) {
            Collection collection = null;
            if (this.collectionExpression != null) {
                collection = (Collection)this.collectionExpression.getValue(execution);
            } else if (this.collectionVariable != null) {
                collection = (Collection)execution.getVariable(this.collectionVariable);
            }
            Object value = null;
            Iterator it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
        if (loopCounter == 0) {
            this.callCustomActivityStartListeners(execution);
            this.innerActivityBehavior.execute(execution);
        } else {
            execution.setCurrentFlowElement((FlowElement)this.activity);
            Context.getAgenda().planContinueMultiInstanceOperation((ExecutionEntity)execution);
        }
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null;
    }

    protected boolean isExtraScopeNeeded(FlowNode flowNode) {
        return flowNode.getSubProcess() != null;
    }

    protected int resolveLoopCardinality(DelegateExecution execution) {
        Object value = this.loopCardinalityExpression.getValue(execution);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new ActivitiIllegalArgumentException("Could not resolve loopCardinality expression '" + this.loopCardinalityExpression.getExpressionText() + "': not a number nor number String");
    }

    protected boolean completionConditionSatisfied(DelegateExecution execution) {
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue(execution);
            if (!(value instanceof Boolean)) {
                throw new ActivitiIllegalArgumentException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    protected void setLoopVariable(DelegateExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLoopVariable(DelegateExecution execution, String variableName) {
        Object value = execution.getVariableLocal(variableName);
        for (DelegateExecution parent = execution.getParent(); value == null && parent != null; parent = parent.getParent()) {
            value = parent.getVariableLocal(variableName);
        }
        return (Integer)(value != null ? value : Integer.valueOf(0));
    }

    protected Integer getLocalLoopVariable(DelegateExecution execution, String variableName) {
        return (Integer)execution.getVariableLocal(variableName);
    }

    protected void removeLocalLoopVariable(DelegateExecution execution, String variableName) {
        execution.removeVariableLocal(variableName);
    }

    protected void callCustomActivityStartListeners(DelegateExecution execution) {
        List listeners = this.activity.getExecutionListeners();
        if (CollectionUtils.isNotEmpty((Collection)listeners)) {
            ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
            for (ActivitiListener activitiListener : listeners) {
                if (!"start".equalsIgnoreCase(activitiListener.getEvent())) continue;
                ExecutionListener executionListener = null;
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    if (!ActivityInstanceStartHandler.class.getName().equals(activitiListener.getImplementation())) {
                        executionListener = listenerFactory.createClassDelegateExecutionListener(activitiListener);
                    }
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createExpressionExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createDelegateExpressionExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_INSTANCE.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    Object executionListenerInstance = activitiListener.getInstance();
                    if (executionListenerInstance instanceof ExecutionListener) {
                        executionListener = (ExecutionListener)executionListenerInstance;
                    } else {
                        LOGGER.warn("Execution listener instance " + executionListenerInstance + " is not of type " + ExecutionListener.class);
                    }
                }
                if (executionListener == null) continue;
                ((ExecutionEntity)execution).setEventName("start");
                executionListener.notify(execution);
            }
        }
    }

    protected void callActivityEndListeners(DelegateExecution execution) {
        List listeners = this.activity.getExecutionListeners();
        if (CollectionUtils.isNotEmpty((Collection)listeners)) {
            ListenerFactory listenerFactory = Context.getProcessEngineConfiguration().getListenerFactory();
            for (ActivitiListener activitiListener : listeners) {
                if (!"end".equalsIgnoreCase(activitiListener.getEvent())) continue;
                ExecutionListener executionListener = null;
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createClassDelegateExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createExpressionExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    executionListener = listenerFactory.createDelegateExpressionExecutionListener(activitiListener);
                } else if (ImplementationType.IMPLEMENTATION_TYPE_INSTANCE.equalsIgnoreCase(activitiListener.getImplementationType())) {
                    Object executionListenerInstance = activitiListener.getInstance();
                    if (executionListenerInstance instanceof ExecutionListener) {
                        executionListener = (ExecutionListener)executionListenerInstance;
                    } else {
                        LOGGER.warn("Execution listener instance " + executionListenerInstance + " is not of type " + ExecutionListener.class);
                    }
                }
                if (executionListener == null) continue;
                ((ExecutionEntity)execution).setEventName("end");
                executionListener.notify(execution);
            }
        }
    }

    protected void logLoopDetails(DelegateExecution execution, String custom, int loopCounter, int nrOfCompletedInstances, int nrOfActiveInstances, int nrOfInstances) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Multi-instance '{}' {}. Details: loopCounter={}, nrOrCompletedInstances={},nrOfActiveInstances={},nrOfInstances={}", new Object[]{execution.getCurrentFlowElement(), custom, loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances});
        }
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public Expression getCompletionConditionExpression() {
        return this.completionConditionExpression;
    }

    public void setCompletionConditionExpression(Expression completionConditionExpression) {
        this.completionConditionExpression = completionConditionExpression;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }

    public String getCollectionElementIndexVariable() {
        return this.collectionElementIndexVariable;
    }

    public void setCollectionElementIndexVariable(String collectionElementIndexVariable) {
        this.collectionElementIndexVariable = collectionElementIndexVariable;
    }

    public void setInnerActivityBehavior(AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.innerActivityBehavior = innerActivityBehavior;
        this.innerActivityBehavior.setMultiInstanceActivityBehavior(this);
    }

    public AbstractBpmnActivityBehavior getInnerActivityBehavior() {
        return this.innerActivityBehavior;
    }
}

