/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Collection;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.CompensateEventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Transaction;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.commons.collections.CollectionUtils;

public class SequentialMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public SequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    @Override
    protected void createInstances(DelegateExecution execution) {
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances < 0) {
            throw new ActivitiIllegalArgumentException("Invalid number of instances: must be a non-negative integer value, but was " + nrOfInstances);
        }
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", 1);
        this.logLoopDetails(execution, "initialized", 0, 0, 1, nrOfInstances);
        if (nrOfInstances > 0) {
            this.executeOriginalBehavior(execution, 0);
        }
    }

    @Override
    public void leave(DelegateExecution execution) {
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances");
        this.setLoopVariable(execution, this.getCollectionElementIndexVariable(), loopCounter);
        this.setLoopVariable(execution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        this.callActivityEndListeners(execution);
        if (loopCounter >= nrOfInstances || this.completionConditionSatisfied(execution)) {
            boolean hasCompensation = false;
            Activity activity = (Activity)execution.getCurrentFlowElement();
            if (activity instanceof Transaction) {
                hasCompensation = true;
            } else if (activity instanceof SubProcess) {
                SubProcess subProcess = (SubProcess)activity;
                block3: for (FlowElement subElement : subProcess.getFlowElements()) {
                    Activity subActivity;
                    if (!(subElement instanceof Activity) || !CollectionUtils.isNotEmpty((Collection)(subActivity = (Activity)subElement).getBoundaryEvents())) continue;
                    for (BoundaryEvent boundaryEvent : subActivity.getBoundaryEvents()) {
                        if (!CollectionUtils.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                        hasCompensation = true;
                        continue block3;
                    }
                }
            }
            if (hasCompensation) {
                ExecutionEntity executionEntity = (ExecutionEntity)execution;
                ScopeUtil.createCopyOfSubProcessExecutionForCompensation(executionEntity, executionEntity.getParent());
            }
            this.removeLocalLoopVariable(execution, this.getCollectionElementIndexVariable());
            super.leave(execution);
        } else {
            try {
                this.executeOriginalBehavior(execution, loopCounter);
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new ActivitiException("Could not execute inner activity behavior of multi instance behavior", e);
            }
        }
    }
}

