/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.JavaDelegate;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.TaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ClassDelegate;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.bpmn.helper.SkipExpressionUtil;
import org.activiti.engine.impl.bpmn.parser.FieldDeclaration;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.activiti.engine.impl.delegate.ActivityBehaviorInvocation;
import org.activiti.engine.impl.delegate.TriggerableActivityBehavior;
import org.activiti.engine.impl.delegate.invocation.JavaDelegateInvocation;

public class ServiceTaskDelegateExpressionActivityBehavior
extends TaskActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected Expression expression;
    protected Expression skipExpression;
    private final List<FieldDeclaration> fieldDeclarations;

    public ServiceTaskDelegateExpressionActivityBehavior(Expression expression, Expression skipExpression, List<FieldDeclaration> fieldDeclarations) {
        this.expression = expression;
        this.skipExpression = skipExpression;
        this.fieldDeclarations = fieldDeclarations;
    }

    @Override
    public void trigger(DelegateExecution execution, String signalName, Object signalData) {
        Object delegate = this.expression.getValue(execution);
        if (delegate instanceof TriggerableActivityBehavior) {
            ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, delegate);
            ((TriggerableActivityBehavior)delegate).trigger(execution, signalName, signalData);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(DelegateExecution execution) {
        try {
            boolean isSkipExpressionEnabled = SkipExpressionUtil.isSkipExpressionEnabled(execution, this.skipExpression);
            if (!isSkipExpressionEnabled || isSkipExpressionEnabled && !SkipExpressionUtil.shouldSkipFlowElement(execution, this.skipExpression)) {
                Object object = this.expression.getValue(execution);
                ClassDelegate.applyFieldDeclaration(this.fieldDeclarations, object);
                if (object instanceof ActivityBehavior) {
                    if (object instanceof AbstractBpmnActivityBehavior) {
                        ((AbstractBpmnActivityBehavior)object).setMultiInstanceActivityBehavior(this.getMultiInstanceActivityBehavior());
                    }
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ActivityBehaviorInvocation((ActivityBehavior)object, execution));
                    return;
                } else {
                    if (!(object instanceof JavaDelegate)) throw new ActivitiIllegalArgumentException("Delegate expression " + this.expression + " did neither resolve to an implementation of " + ActivityBehavior.class + " nor " + JavaDelegate.class);
                    Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new JavaDelegateInvocation((JavaDelegate)object, execution));
                    this.leave(execution);
                }
                return;
            } else {
                this.leave(execution);
            }
            return;
        }
        catch (Exception exc) {
            void var3_6;
            Exception exception = exc;
            BpmnError error = null;
            while (var3_6 != null) {
                if (var3_6 instanceof BpmnError) {
                    error = (BpmnError)var3_6;
                    break;
                }
                Throwable throwable = var3_6.getCause();
            }
            if (error == null) throw new ActivitiException(exc.getMessage(), exc);
            ErrorPropagation.propagateError(error, execution);
            return;
        }
    }
}

