/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.apache.commons.collections.CollectionUtils;

public class SubProcessActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(DelegateExecution execution) {
        SubProcess subProcess = this.getSubProcessFromExecution(execution);
        StartEvent startElement = null;
        if (CollectionUtils.isNotEmpty((Collection)subProcess.getFlowElements())) {
            for (FlowElement subElement : subProcess.getFlowElements()) {
                StartEvent startEvent;
                if (!(subElement instanceof StartEvent) || !CollectionUtils.isEmpty((Collection)(startEvent = (StartEvent)subElement).getEventDefinitions())) continue;
                startElement = startEvent;
                break;
            }
        }
        if (startElement == null) {
            throw new ActivitiException("No initial activity found for subprocess " + subProcess.getId());
        }
        execution.setScope(true);
        Map<String, Object> dataObjectVars = this.processDataObjects(subProcess.getDataObjects());
        if (dataObjectVars != null) {
            execution.setVariablesLocal(dataObjectVars);
        }
        ExecutionEntity startSubProcessExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
        startSubProcessExecution.setCurrentFlowElement((FlowElement)startElement);
        Context.getAgenda().planContinueProcessOperation(startSubProcessExecution);
    }

    protected SubProcess getSubProcessFromExecution(DelegateExecution execution) {
        FlowElement flowElement = execution.getCurrentFlowElement();
        SubProcess subProcess = null;
        if (!(flowElement instanceof SubProcess)) {
            throw new ActivitiException("Programmatic error: sub process behaviour can only be applied to a SubProcess instance, but got an instance of " + flowElement);
        }
        subProcess = (SubProcess)flowElement;
        return subProcess;
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

