/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.tree.ExecutionTree;
import org.activiti.engine.impl.util.tree.ExecutionTreeBfsIterator;
import org.activiti.engine.impl.util.tree.ExecutionTreeNode;

public class TerminateEndEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected boolean destroyProcessInstance;

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        ExecutionTree executionTree = executionEntityManager.findExecutionTree(execution.getRootProcessInstanceId());
        if (!this.destroyProcessInstance) {
            ExecutionTreeNode scopeTreeNode = executionTree.getTreeNode(execution.getId());
            while (!scopeTreeNode.getExecutionEntity().isScope() && (scopeTreeNode = scopeTreeNode.getParent()) != null) {
            }
            ExecutionEntity scopeExecutionEntity = scopeTreeNode.getExecutionEntity();
            this.sendProcessInstanceCancelledEvent(scopeExecutionEntity, execution.getCurrentFlowElement());
            if (scopeExecutionEntity.getParentId() == null) {
                if (scopeExecutionEntity.getSuperExecutionId() != null) {
                    executionEntityManager.deleteProcessInstanceExecutionEntity(scopeExecutionEntity.getId(), execution.getCurrentFlowElement().getId(), "terminate end event", false, false, true);
                    ExecutionEntity superExecutionEntity = (ExecutionEntity)executionEntityManager.findById(scopeExecutionEntity.getSuperExecutionId());
                    commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation(superExecutionEntity);
                } else {
                    this.deleteExecutionEntities(commandContext, executionEntityManager, executionTree.leafsFirstIterator());
                }
            } else {
                SubProcess subProcess = null;
                boolean isMultiInstance = false;
                if (scopeExecutionEntity.getCurrentFlowElement() instanceof SubProcess && (subProcess = (SubProcess)scopeExecutionEntity.getCurrentFlowElement()).getLoopCharacteristics() != null) {
                    isMultiInstance = true;
                }
                if (isMultiInstance) {
                    MultiInstanceActivityBehavior multiInstanceBehavior = (MultiInstanceActivityBehavior)subProcess.getBehavior();
                    multiInstanceBehavior.leave(scopeExecutionEntity);
                    if (!subProcess.getLoopCharacteristics().isSequential()) {
                        commandContext.getAgenda().planDestroyScopeOperation(scopeExecutionEntity);
                    }
                } else {
                    commandContext.getAgenda().planDestroyScopeOperation(scopeExecutionEntity);
                    commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation(scopeExecutionEntity);
                }
            }
        }
    }

    protected void deleteExecutionEntities(CommandContext commandContext, ExecutionEntityManager executionEntityManager, ExecutionTreeBfsIterator treeIterator) {
        while (treeIterator.hasNext()) {
            ExecutionTreeNode treeNode = treeIterator.next();
            ExecutionEntity executionEntity = treeNode.getExecutionEntity();
            executionEntityManager.deleteExecutionAndRelatedData(executionEntity, null, false);
        }
    }

    protected void sendProcessInstanceCancelledEvent(DelegateExecution execution, FlowElement terminateEndEvent) {
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), execution.getCurrentFlowElement()));
        }
        this.dispatchExecutionCancelled(execution, terminateEndEvent);
    }

    protected void dispatchExecutionCancelled(DelegateExecution execution, FlowElement terminateEndEvent) {
        FlowElement flowElement;
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        for (DelegateExecution delegateExecution : executionEntityManager.findChildExecutionsByParentExecutionId(execution.getId())) {
            this.dispatchExecutionCancelled(delegateExecution, terminateEndEvent);
        }
        ExecutionEntity subProcessInstance = Context.getCommandContext().getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId());
        if (subProcessInstance != null) {
            this.dispatchExecutionCancelled(subProcessInstance, terminateEndEvent);
        }
        if ((flowElement = execution.getCurrentFlowElement()) != null && flowElement instanceof FlowNode) {
            this.dispatchActivityCancelled(execution, terminateEndEvent);
        }
    }

    protected void dispatchActivityCancelled(DelegateExecution execution, FlowElement terminateEndEvent) {
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(execution.getCurrentFlowElement().getId(), execution.getCurrentFlowElement().getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), execution.getCurrentFlowElement().getClass().getName(), ((FlowNode)execution.getCurrentFlowElement()).getBehavior().getClass().getCanonicalName(), terminateEndEvent));
    }

    protected boolean hasMultiInstanceParent(FlowNode flowNode) {
        boolean hasMultiInstanceParent = false;
        if (flowNode.getSubProcess() != null) {
            if (flowNode.getSubProcess().getLoopCharacteristics() != null) {
                hasMultiInstanceParent = true;
            } else {
                boolean hasNestedMultiInstanceParent = this.hasMultiInstanceParent((FlowNode)flowNode.getSubProcess());
                if (hasNestedMultiInstanceParent) {
                    hasMultiInstanceParent = true;
                }
            }
        }
        return hasMultiInstanceParent;
    }
}

