/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.util.tree.ExecutionTree;
import org.activiti.engine.impl.util.tree.ExecutionTreeNode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ErrorPropagation {
    public static void propagateError(BpmnError error, DelegateExecution execution) {
        ErrorPropagation.propagateError(error.getErrorCode(), execution);
    }

    public static void propagateError(String errorCode, DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager;
        ExecutionTree executionTree;
        ExecutionTreeNode rootNode;
        ExecutionTreeNode existingNode;
        Map<String, List<Event>> eventMap = ErrorPropagation.findCatchingEventsForProcess(execution.getProcessDefinitionId(), errorCode);
        if (eventMap.size() > 0) {
            ErrorPropagation.executeCatch(eventMap, execution, errorCode);
        } else if (!execution.getProcessInstanceId().equals(execution.getRootProcessInstanceId()) && (existingNode = ErrorPropagation.getCurrentExecutionTreeNode(rootNode = (executionTree = (executionEntityManager = Context.getCommandContext().getExecutionEntityManager()).findExecutionTree(execution.getRootProcessInstanceId())).getRoot(), execution.getProcessInstanceId())) != null) {
            ExecutionTreeNode parentNode = existingNode.getParent();
            HashSet<String> toDeleteProcessInstanceIds = new HashSet<String>();
            toDeleteProcessInstanceIds.add(execution.getProcessInstanceId());
            while (parentNode != null && eventMap.size() == 0) {
                eventMap = ErrorPropagation.findCatchingEventsForProcess(parentNode.getExecutionEntity().getProcessDefinitionId(), errorCode);
                if (eventMap.size() > 0) {
                    for (String processInstanceId : toDeleteProcessInstanceIds) {
                        ExecutionEntity processInstanceEntity = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
                        executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceEntity.getId(), execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : null, "ERROR_EVENT " + errorCode, false, false, false);
                        if (Context.getProcessEngineConfiguration() == null || !Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) continue;
                        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, processInstanceEntity));
                    }
                    ErrorPropagation.executeCatch(eventMap, parentNode.getExecutionEntity(), errorCode);
                    continue;
                }
                toDeleteProcessInstanceIds.add(parentNode.getExecutionEntity().getProcessInstanceId());
                parentNode = parentNode.getParent();
            }
        }
        if (eventMap.size() == 0) {
            throw new BpmnError(errorCode, "No catching boundary event found for error with errorCode '" + errorCode + "', neither in same process nor in parent process");
        }
    }

    protected static void executeCatch(Map<String, List<Event>> eventMap, DelegateExecution delegateExecution, String errorId) {
        Event matchingEvent = null;
        ExecutionEntity currentExecution = (ExecutionEntity)delegateExecution;
        if (eventMap.containsKey(currentExecution.getActivityId())) {
            matchingEvent = eventMap.get(currentExecution.getActivityId()).get(0);
            FlowElement parentElement = currentExecution.getParent().getCurrentFlowElement();
            if (parentElement != null && parentElement.getId().equals(currentExecution.getCurrentFlowElement().getId())) {
                currentExecution = currentExecution.getParent();
            }
        } else {
            currentExecution = currentExecution.getParent();
            while (matchingEvent == null && currentExecution != null) {
                FlowElementsContainer currentContainer = null;
                if (currentExecution.getCurrentFlowElement() instanceof FlowElementsContainer) {
                    currentContainer = (FlowElementsContainer)currentExecution.getCurrentFlowElement();
                } else if (currentExecution.getId().equals(currentExecution.getProcessInstanceId())) {
                    currentContainer = ProcessDefinitionUtil.getProcess(currentExecution.getProcessDefinitionId());
                }
                for (String refId : eventMap.keySet()) {
                    List<Event> events = eventMap.get(refId);
                    if (!CollectionUtils.isNotEmpty(events) || !(events.get(0) instanceof StartEvent) || currentContainer.getFlowElement(refId) == null) continue;
                    matchingEvent = events.get(0);
                }
                if (matchingEvent != null) continue;
                if (eventMap.containsKey(currentExecution.getActivityId())) {
                    matchingEvent = eventMap.get(currentExecution.getActivityId()).get(0);
                    FlowElement parentElement = currentExecution.getParent().getCurrentFlowElement();
                    if (parentElement == null || !parentElement.getId().equals(currentExecution.getCurrentFlowElement().getId())) continue;
                    currentExecution = currentExecution.getParent();
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)currentExecution.getParentId())) {
                    currentExecution = currentExecution.getParent();
                    continue;
                }
                currentExecution = null;
            }
        }
        if (matchingEvent == null || currentExecution == null) {
            throw new ActivitiException("No matching parent execution for error code " + errorId + " found");
        }
        ErrorPropagation.executeEventHandler(matchingEvent, currentExecution, errorId);
    }

    protected static void executeEventHandler(Event event, ExecutionEntity parentExecution, String errorId) {
        BpmnModel bpmnModel;
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId())) != null) {
            String errorCode = (String)bpmnModel.getErrors().get(errorId);
            if (errorCode == null) {
                errorCode = errorId;
            }
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createErrorEvent(ActivitiEventType.ACTIVITY_ERROR_RECEIVED, event.getId(), errorId, errorCode, parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId()));
        }
        if (event instanceof StartEvent) {
            parentExecution.setCurrentFlowElement((FlowElement)event);
            Context.getAgenda().planContinueProcessOperation(parentExecution);
        } else {
            ExecutionEntity boundaryExecution = null;
            List<ExecutionEntity> childExecutions = parentExecution.getExecutions();
            for (ExecutionEntity childExecution : childExecutions) {
                if (!childExecution.getActivityId().equals(event.getId())) continue;
                boundaryExecution = childExecution;
            }
            Context.getAgenda().planTriggerExecutionOperation(boundaryExecution);
        }
    }

    protected static Map<String, List<Event>> findCatchingEventsForProcess(String processDefinitionId, String errorCode) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        String compareErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorCode);
        List subProcesses = process.findFlowElementsOfType(EventSubProcess.class, true);
        for (EventSubProcess eventSubProcess : subProcesses) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                ErrorEventDefinition errorEventDef;
                String eventErrorCode;
                StartEvent startEvent;
                if (!(flowElement instanceof StartEvent) || !CollectionUtils.isNotEmpty((Collection)(startEvent = (StartEvent)flowElement).getEventDefinitions()) || !(startEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)startEvent.getEventDefinitions().get(0)).getErrorCode())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
                ArrayList<StartEvent> startEvents = new ArrayList<StartEvent>();
                startEvents.add(startEvent);
                eventMap.put(eventSubProcess.getId(), startEvents);
            }
        }
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            ErrorEventDefinition errorEventDef;
            String eventErrorCode;
            if (boundaryEvent.getAttachedToRefId() == null || !CollectionUtils.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof ErrorEventDefinition) || (eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, (errorEventDef = (ErrorEventDefinition)boundaryEvent.getEventDefinitions().get(0)).getErrorCode())) != null && compareErrorCode != null && !eventErrorCode.equals(compareErrorCode)) continue;
            List<BoundaryEvent> elementBoundaryEvents = null;
            if (!eventMap.containsKey(boundaryEvent.getAttachedToRefId())) {
                elementBoundaryEvents = new ArrayList();
                eventMap.put(boundaryEvent.getAttachedToRefId(), elementBoundaryEvents);
            } else {
                elementBoundaryEvents = (List)eventMap.get(boundaryEvent.getAttachedToRefId());
            }
            elementBoundaryEvents.add(boundaryEvent);
        }
        return eventMap;
    }

    public static boolean mapException(Exception e, ExecutionEntity execution, List<MapExceptionEntry> exceptionMap) {
        CallActivity callActivity;
        String errorCode = ErrorPropagation.findMatchingExceptionMapping(e, exceptionMap);
        if (errorCode != null) {
            ErrorPropagation.propagateError(errorCode, (DelegateExecution)execution);
            return true;
        }
        ExecutionEntity callActivityExecution = null;
        ExecutionEntity parentExecution = execution.getParent();
        while (parentExecution != null && callActivityExecution == null) {
            if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                if (parentExecution.getSuperExecution() != null) {
                    callActivityExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
                continue;
            }
            parentExecution = parentExecution.getParent();
        }
        if (callActivityExecution != null && CollectionUtils.isNotEmpty((Collection)(callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement()).getMapExceptions()) && (errorCode = ErrorPropagation.findMatchingExceptionMapping(e, callActivity.getMapExceptions())) != null) {
            ErrorPropagation.propagateError(errorCode, (DelegateExecution)callActivityExecution);
            return true;
        }
        return false;
    }

    protected static String findMatchingExceptionMapping(Exception e, List<MapExceptionEntry> exceptionMap) {
        String defaultExceptionMapping = null;
        for (MapExceptionEntry me : exceptionMap) {
            Class<?> exceptionClassClass;
            String exceptionClass = me.getClassName();
            String errorCode = me.getErrorCode();
            if (StringUtils.isNotEmpty((CharSequence)errorCode) && StringUtils.isEmpty((CharSequence)exceptionClass) && defaultExceptionMapping == null) {
                defaultExceptionMapping = errorCode;
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)exceptionClass)) continue;
            if (e.getClass().getName().equals(exceptionClass)) {
                return errorCode;
            }
            if (!me.isAndChildren() || !(exceptionClassClass = ReflectUtil.loadClass(exceptionClass)).isAssignableFrom(e.getClass())) continue;
            return errorCode;
        }
        return defaultExceptionMapping;
    }

    protected static ExecutionTreeNode getCurrentExecutionTreeNode(ExecutionTreeNode treeNode, String processInstanceId) {
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
            ExecutionEntity childEntity = treeNode.getChildren().get(0).getExecutionEntity();
            if (childEntity != null && childEntity.getProcessInstanceId() != null && childEntity.getProcessInstanceId().equals(processInstanceId)) {
                return treeNode.getChildren().get(0);
            }
            for (ExecutionTreeNode childTreeNode : treeNode.getChildren()) {
                ExecutionTreeNode searchedNode = ErrorPropagation.getCurrentExecutionTreeNode(childTreeNode, processInstanceId);
                if (searchedNode == null) continue;
                return searchedNode;
            }
        }
        return null;
    }

    protected static String retrieveErrorCode(BpmnModel bpmnModel, String errorCode) {
        String finalErrorCode = null;
        finalErrorCode = errorCode != null && bpmnModel.containsErrorRef(errorCode) ? (String)bpmnModel.getErrors().get(errorCode) : errorCode;
        return finalErrorCode;
    }
}

