/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.Artifact;
import org.activiti.bpmn.model.Association;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DataSpec;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOSpecification;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.bpmn.data.Data;
import org.activiti.engine.impl.bpmn.data.DataRef;
import org.activiti.engine.impl.bpmn.data.ItemDefinition;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.parse.BpmnParseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBpmnParseHandler<T extends BaseElement>
implements BpmnParseHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBpmnParseHandler.class);
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        HashSet<Class<? extends BaseElement>> types = new HashSet<Class<? extends BaseElement>>();
        types.add(this.getHandledType());
        return types;
    }

    protected abstract Class<? extends BaseElement> getHandledType();

    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        BaseElement baseElement = element;
        this.executeParse(bpmnParse, baseElement);
    }

    protected abstract void executeParse(BpmnParse var1, T var2);

    protected ExecutionListener createExecutionListener(BpmnParse bpmnParse, ActivitiListener activitiListener) {
        ExecutionListener executionListener = null;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createClassDelegateExecutionListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createExpressionExecutionListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createDelegateExpressionExecutionListener(activitiListener);
        }
        return executionListener;
    }

    protected String getPrecedingEventBasedGateway(BpmnParse bpmnParse, IntermediateCatchEvent event) {
        String eventBasedGatewayId = null;
        for (SequenceFlow sequenceFlow : event.getIncomingFlows()) {
            FlowElement sourceElement = bpmnParse.getBpmnModel().getFlowElement(sequenceFlow.getSourceRef());
            if (!(sourceElement instanceof EventGateway)) continue;
            eventBasedGatewayId = sourceElement.getId();
            break;
        }
        return eventBasedGatewayId;
    }

    protected org.activiti.engine.impl.bpmn.data.IOSpecification createIOSpecification(BpmnParse bpmnParse, IOSpecification specificationModel) {
        DataRef dataRef;
        ItemDefinition itemDefinition;
        org.activiti.engine.impl.bpmn.data.IOSpecification ioSpecification = new org.activiti.engine.impl.bpmn.data.IOSpecification();
        for (DataSpec dataInputElement : specificationModel.getDataInputs()) {
            itemDefinition = bpmnParse.getItemDefinitions().get(dataInputElement.getItemSubjectRef());
            Data dataInput = new Data(bpmnParse.getTargetNamespace() + ":" + dataInputElement.getId(), dataInputElement.getId(), itemDefinition);
            ioSpecification.addInput(dataInput);
        }
        for (DataSpec dataOutputElement : specificationModel.getDataOutputs()) {
            itemDefinition = bpmnParse.getItemDefinitions().get(dataOutputElement.getItemSubjectRef());
            Data dataOutput = new Data(bpmnParse.getTargetNamespace() + ":" + dataOutputElement.getId(), dataOutputElement.getId(), itemDefinition);
            ioSpecification.addOutput(dataOutput);
        }
        for (String dataInputRef : specificationModel.getDataInputRefs()) {
            dataRef = new DataRef(dataInputRef);
            ioSpecification.addInputRef(dataRef);
        }
        for (String dataOutputRef : specificationModel.getDataOutputRefs()) {
            dataRef = new DataRef(dataOutputRef);
            ioSpecification.addOutputRef(dataRef);
        }
        return ioSpecification;
    }

    protected void processArtifacts(BpmnParse bpmnParse, Collection<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!(artifact instanceof Association)) continue;
            this.createAssociation(bpmnParse, (Association)artifact);
        }
    }

    protected void createAssociation(BpmnParse bpmnParse, Association association) {
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (bpmnModel.getArtifact(association.getSourceRef()) != null || bpmnModel.getArtifact(association.getTargetRef()) != null) {
            return;
        }
    }

    protected Map<String, Object> processDataObjects(BpmnParse bpmnParse, Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

