/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.DataAssociation;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.SendTask;
import org.activiti.engine.impl.bpmn.behavior.WebServiceActivityBehavior;
import org.activiti.engine.impl.bpmn.data.AbstractDataAssociation;
import org.activiti.engine.impl.bpmn.data.IOSpecification;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractExternalInvocationBpmnParseHandler;
import org.activiti.engine.impl.bpmn.webservice.Operation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendTaskParseHandler
extends AbstractExternalInvocationBpmnParseHandler<SendTask> {
    private static final Logger logger = LoggerFactory.getLogger(SendTaskParseHandler.class);

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return SendTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, SendTask sendTask) {
        if (StringUtils.isNotEmpty((CharSequence)sendTask.getType())) {
            if (sendTask.getType().equalsIgnoreCase("mail")) {
                sendTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMailActivityBehavior(sendTask));
            } else if (sendTask.getType().equalsIgnoreCase("mule")) {
                sendTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createMuleActivityBehavior(sendTask));
            } else if (sendTask.getType().equalsIgnoreCase("camel")) {
                sendTask.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createCamelActivityBehavior(sendTask));
            }
        } else if (ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE.equalsIgnoreCase(sendTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)sendTask.getOperationRef())) {
            if (!bpmnParse.getOperations().containsKey(sendTask.getOperationRef())) {
                logger.warn(sendTask.getOperationRef() + " does not exist for sendTask " + sendTask.getId());
            } else {
                AbstractDataAssociation dataAssociation;
                WebServiceActivityBehavior webServiceActivityBehavior = bpmnParse.getActivityBehaviorFactory().createWebServiceActivityBehavior(sendTask);
                Operation operation = bpmnParse.getOperations().get(sendTask.getOperationRef());
                webServiceActivityBehavior.setOperation(operation);
                if (sendTask.getIoSpecification() != null) {
                    IOSpecification ioSpecification = this.createIOSpecification(bpmnParse, sendTask.getIoSpecification());
                    webServiceActivityBehavior.setIoSpecification(ioSpecification);
                }
                for (DataAssociation dataAssociationElement : sendTask.getDataInputAssociations()) {
                    dataAssociation = this.createDataInputAssociation(bpmnParse, dataAssociationElement);
                    webServiceActivityBehavior.addDataInputAssociation(dataAssociation);
                }
                for (DataAssociation dataAssociationElement : sendTask.getDataOutputAssociations()) {
                    dataAssociation = this.createDataOutputAssociation(bpmnParse, dataAssociationElement);
                    webServiceActivityBehavior.addDataOutputAssociation(dataAssociation);
                }
                sendTask.setBehavior((Object)webServiceActivityBehavior);
            }
        } else {
            logger.warn("One of the attributes 'type' or 'operation' is mandatory on sendTask " + sendTask.getId());
        }
    }
}

