/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.runtime.Execution;

public abstract class AbstractSetProcessInstanceStateCmd
implements Command<Void> {
    protected final String executionId;

    public AbstractSetProcessInstanceStateCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiIllegalArgumentException("ProcessInstanceId cannot be null.");
        }
        ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (executionEntity == null) {
            throw new ActivitiObjectNotFoundException("Cannot find processInstance for id '" + this.executionId + "'.", Execution.class);
        }
        if (!executionEntity.isProcessInstanceType()) {
            throw new ActivitiException("Cannot set suspension state for execution '" + this.executionId + "': not a process instance.");
        }
        if (Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, executionEntity.getProcessDefinitionId())) {
            if (this.getNewState() == SuspensionState.ACTIVE) {
                commandContext.getProcessEngineConfiguration().getActiviti5CompatibilityHandler().activateProcessInstance(this.executionId);
            } else {
                commandContext.getProcessEngineConfiguration().getActiviti5CompatibilityHandler().suspendProcessInstance(this.executionId);
            }
            return null;
        }
        SuspensionState.SuspensionStateUtil.setSuspensionState(executionEntity, this.getNewState());
        List<ExecutionEntity> childExecutions = commandContext.getExecutionEntityManager().findChildExecutionsByProcessInstanceId(this.executionId);
        for (ExecutionEntity childExecution : childExecutions) {
            if (childExecution.getId().equals(this.executionId)) continue;
            SuspensionState.SuspensionStateUtil.setSuspensionState(childExecution, this.getNewState());
        }
        List<TaskEntity> tasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(this.executionId);
        for (TaskEntity taskEntity : tasks) {
            SuspensionState.SuspensionStateUtil.setSuspensionState(taskEntity, this.getNewState());
        }
        return null;
    }

    protected abstract SuspensionState getNewState();
}

