/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.Activiti5Util;

public class AddIdentityLinkCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    public static int IDENTITY_USER = 1;
    public static int IDENTITY_GROUP = 2;
    protected String identityId;
    protected int identityIdType;
    protected String identityType;

    public AddIdentityLinkCmd(String taskId, String identityId, int identityIdType, String identityType) {
        super(taskId);
        this.validateParams(taskId, identityId, identityIdType, identityType);
        this.taskId = taskId;
        this.identityId = identityId;
        this.identityIdType = identityIdType;
        this.identityType = identityType;
    }

    protected void validateParams(String taskId, String identityId, int identityIdType, String identityType) {
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        if (identityType == null) {
            throw new ActivitiIllegalArgumentException("type is required when adding a new task identity link");
        }
        if (identityId == null && (identityIdType == IDENTITY_GROUP || !"assignee".equals(identityType) && !"owner".equals(identityType))) {
            throw new ActivitiIllegalArgumentException("identityId is null");
        }
        if (identityIdType != IDENTITY_USER && identityIdType != IDENTITY_GROUP) {
            throw new ActivitiIllegalArgumentException("identityIdType allowed values are 1 and 2");
        }
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (task.getProcessDefinitionId() != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.addIdentityLink(this.taskId, this.identityId, this.identityIdType, this.identityType);
            return null;
        }
        boolean assignedToNoOne = false;
        if ("assignee".equals(this.identityType)) {
            task.setAssignee(this.identityId, true, true);
            assignedToNoOne = this.identityId == null;
        } else if ("owner".equals(this.identityType)) {
            task.setOwner(this.identityId, true);
        } else if (IDENTITY_USER == this.identityIdType) {
            task.addUserIdentityLink(this.identityId, this.identityType);
        } else if (IDENTITY_GROUP == this.identityIdType) {
            task.addGroupIdentityLink(this.identityId, this.identityType);
        }
        boolean forceNullUserId = false;
        if (assignedToNoOne) {
            forceNullUserId = true;
        }
        if (IDENTITY_USER == this.identityIdType) {
            commandContext.getHistoryManager().createUserIdentityLinkComment(this.taskId, this.identityId, this.identityType, true, forceNullUserId);
        } else {
            commandContext.getHistoryManager().createGroupIdentityLinkComment(this.taskId, this.identityId, this.identityType, true);
        }
        return null;
    }
}

