/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.ProcessDefinition;

public class ChangeDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;

    public ChangeDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new ActivitiIllegalArgumentException("deploymentId is null");
        }
        DeploymentEntity deployment = (DeploymentEntity)commandContext.getDeploymentEntityManager().findById(this.deploymentId);
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("Could not find deployment with id " + this.deploymentId, Deployment.class);
        }
        if (commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled() && "activiti-5".equals(deployment.getEngineVersion())) {
            commandContext.getProcessEngineConfiguration().getActiviti5CompatibilityHandler().changeDeploymentTenantId(this.deploymentId, this.newTenantId);
            return null;
        }
        String oldTenantId = deployment.getTenantId();
        deployment.setTenantId(this.newTenantId);
        commandContext.getProcessDefinitionEntityManager().updateProcessDefinitionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getExecutionEntityManager().updateExecutionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getTaskEntityManager().updateTaskTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getJobEntityManager().updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        commandContext.getEventSubscriptionEntityManager().updateEventSubscriptionTenantId(oldTenantId, this.newTenantId);
        List processDefinitions = commandContext.getDbSqlSession().createProcessDefinitionQuery().deploymentId(this.deploymentId).list();
        for (ProcessDefinition processDefinition : processDefinitions) {
            commandContext.getProcessEngineConfiguration().getProcessDefinitionCache().remove(processDefinition.getId());
        }
        commandContext.getProcessEngineConfiguration().getProcessDefinitionCache().clear();
        return null;
    }
}

