/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.cmd.NeedsActiveTaskCmd;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.util.Activiti5Util;

public class DeleteIdentityLinkCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    public static int IDENTITY_USER = 1;
    public static int IDENTITY_GROUP = 2;
    protected String userId;
    protected String groupId;
    protected String type;

    public DeleteIdentityLinkCmd(String taskId, String userId, String groupId, String type) {
        super(taskId);
        this.validateParams(userId, groupId, type, taskId);
        this.taskId = taskId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String type, String taskId) {
        if (taskId == null) {
            throw new ActivitiIllegalArgumentException("taskId is null");
        }
        if (type == null) {
            throw new ActivitiIllegalArgumentException("type is required when adding a new task identity link");
        }
        if ("assignee".equals(type) || "owner".equals(type)) {
            if (groupId != null) {
                throw new ActivitiIllegalArgumentException("Incompatible usage: cannot use type '" + type + "' together with a groupId");
            }
        } else if (userId == null && groupId == null) {
            throw new ActivitiIllegalArgumentException("userId and groupId cannot both be null");
        }
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (task.getProcessDefinitionId() != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.deleteIdentityLink(this.taskId, this.userId, this.groupId, this.type);
            return null;
        }
        if ("assignee".equals(this.type)) {
            task.setAssignee(null, true, true);
        } else if ("owner".equals(this.type)) {
            task.setOwner(null, true);
        } else {
            commandContext.getIdentityLinkEntityManager().deleteIdentityLink(task, this.userId, this.groupId, this.type);
        }
        commandContext.getHistoryManager().createIdentityLinkComment(this.taskId, this.userId, this.groupId, this.type, false);
        return null;
    }
}

