/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.runtime.ProcessInstance;

public class DeleteProcessInstanceCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String deleteReason;

    public DeleteProcessInstanceCmd(String processInstanceId, String deleteReason) {
        this.processInstanceId = processInstanceId;
        this.deleteReason = deleteReason;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        ExecutionEntity processInstanceEntity;
        if (this.processInstanceId == null) {
            throw new ActivitiIllegalArgumentException("processInstanceId is null");
        }
        if (this.deleteReason == null) {
            this.deleteReason = "ACTIVITI_DELETED";
        }
        if (commandContext.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            commandContext.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createCancelledEvent(this.processInstanceId, this.processInstanceId, null, this.deleteReason));
        }
        if ((processInstanceEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.processInstanceId)) == null) {
            throw new ActivitiObjectNotFoundException("No process instance found for id '" + this.processInstanceId + "'", ProcessInstance.class);
        }
        if (Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, processInstanceEntity.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.deleteProcessInstance(this.processInstanceId, this.deleteReason);
        } else {
            commandContext.getExecutionEntityManager().deleteProcessInstanceExecutionEntity(processInstanceEntity.getId(), null, this.deleteReason, false, true, true);
        }
        return null;
    }
}

