/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.JobNotFoundException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandContextCloseListener;
import org.activiti.engine.impl.jobexecutor.FailedJobListener;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.util.Activiti5Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteJobsCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ExecuteJobsCmd.class);
    protected String jobId;
    protected JobEntity job;

    public ExecuteJobsCmd(String jobId) {
        this.jobId = jobId;
    }

    public ExecuteJobsCmd(JobEntity job) {
        this.job = job;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.jobId == null && this.job == null) {
            throw new ActivitiIllegalArgumentException("jobId and job is null");
        }
        if (this.job == null) {
            this.job = (JobEntity)commandContext.getJobEntityManager().findById(this.jobId);
        }
        if (this.job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (log.isDebugEnabled()) {
            log.debug("Executing job {}", (Object)this.job.getId());
        }
        if (this.job.getProcessDefinitionId() != null && Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, this.job.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.executeJob(this.job);
            return null;
        }
        commandContext.addCloseListener(new ManualJobExecutionCommandContextCloseListener(this.job));
        try {
            commandContext.getJobEntityManager().execute(this.job);
        }
        catch (Throwable exception) {
            throw new ActivitiException("Job " + this.jobId + " failed", exception);
        }
        return null;
    }

    public String getJobId() {
        return this.jobId;
    }

    public static final class ManualJobExecutionCommandContextCloseListener
    implements CommandContextCloseListener {
        protected JobEntity jobEntity;

        public ManualJobExecutionCommandContextCloseListener(JobEntity jobEntity) {
            this.jobEntity = jobEntity;
        }

        @Override
        public void closing(CommandContext context) {
            if (context.getException() != null) {
                FailedJobListener failedJobListener = null;
                failedJobListener = new FailedJobListener(context.getProcessEngineConfiguration().getCommandExecutor(), this.jobEntity.getId());
                failedJobListener.setException(context.getException());
                context.getTransactionContext().addTransactionListener(TransactionState.ROLLED_BACK, failedJobListener);
                if (context.getEventDispatcher().isEnabled()) {
                    try {
                        context.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityExceptionEvent(ActivitiEventType.JOB_EXECUTION_FAILURE, this.jobEntity, context.getException()));
                    }
                    catch (Throwable ignore) {
                        log.warn("Exception occurred while dispatching job failure event, ignoring.", ignore);
                    }
                }
            } else if (context.getEventDispatcher().isEnabled()) {
                context.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_EXECUTION_SUCCESS, this.jobEntity));
            }
        }

        @Override
        public void closed(CommandContext commandContext) {
        }
    }
}

