/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.form.DefaultFormHandler;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.impl.util.FormHandlerUtil;

public class GetFormKeyCmd
implements Command<String> {
    protected String taskDefinitionKey;
    protected String processDefinitionId;

    public GetFormKeyCmd(String processDefinitionId) {
        this.setProcessDefinitionId(processDefinitionId);
    }

    public GetFormKeyCmd(String processDefinitionId, String taskDefinitionKey) {
        this.setProcessDefinitionId(processDefinitionId);
        if (taskDefinitionKey == null || taskDefinitionKey.length() < 1) {
            throw new ActivitiIllegalArgumentException("The task definition key is mandatory, but '" + taskDefinitionKey + "' has been provided.");
        }
        this.taskDefinitionKey = taskDefinitionKey;
    }

    protected void setProcessDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null || processDefinitionId.length() < 1) {
            throw new ActivitiIllegalArgumentException("The process definition id is mandatory, but '" + processDefinitionId + "' has been provided.");
        }
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String execute(CommandContext commandContext) {
        DefaultFormHandler formHandler;
        ProcessDefinitionEntity processDefinition = commandContext.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(this.processDefinitionId);
        if (this.taskDefinitionKey == null) {
            formHandler = (DefaultFormHandler)((Object)FormHandlerUtil.getStartFormHandler(commandContext, processDefinition));
        } else {
            TaskDefinition taskDefinition = processDefinition.getTaskDefinitions().get(this.taskDefinitionKey);
            formHandler = (DefaultFormHandler)((Object)taskDefinition.getTaskFormHandler());
        }
        String formKey = null;
        if (formHandler.getFormKey() != null) {
            formKey = formHandler.getFormKey().getExpressionText();
        }
        return formKey;
    }
}

