/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.activiti.engine.impl.util.ProcessInstanceUtil;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class StartProcessInstanceCmd<T>
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected Map<String, Object> variables;
    protected String businessKey;
    protected String tenantId;
    protected String processInstanceName;

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables) {
        this.processDefinitionKey = processDefinitionKey;
        this.processDefinitionId = processDefinitionId;
        this.businessKey = businessKey;
        this.variables = variables;
    }

    public StartProcessInstanceCmd(String processDefinitionKey, String processDefinitionId, String businessKey, Map<String, Object> variables, String tenantId) {
        this(processDefinitionKey, processDefinitionId, businessKey, variables);
        this.tenantId = tenantId;
    }

    public StartProcessInstanceCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        this(processInstanceBuilder.getProcessDefinitionKey(), processInstanceBuilder.getProcessDefinitionId(), processInstanceBuilder.getBusinessKey(), processInstanceBuilder.getVariables(), processInstanceBuilder.getTenantId());
        this.processInstanceName = processInstanceBuilder.getProcessInstanceName();
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        DeploymentManager deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinitionEntity processDefinition = null;
        if (this.processDefinitionId != null) {
            processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
            }
        } else if (this.processDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId))) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(this.processDefinitionKey);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "'", ProcessDefinition.class);
            }
        } else if (this.processDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId)) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKeyAndTenantId(this.processDefinitionKey, this.tenantId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for key '" + this.processDefinitionKey + "' for tenant identifier " + this.tenantId, ProcessDefinition.class);
            }
        } else {
            throw new ActivitiIllegalArgumentException("processDefinitionKey and processDefinitionId are null");
        }
        ProcessInstance processInstance = this.createAndStartProcessInstance(processDefinition, this.businessKey, this.processInstanceName, this.variables);
        return processInstance;
    }

    protected ProcessInstance createAndStartProcessInstance(ProcessDefinitionEntity processDefinition, String businessKey, String processInstanceName, Map<String, Object> variables) {
        return ProcessInstanceUtil.createAndStartProcessInstance(processDefinition, businessKey, processInstanceName, variables);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }
}

