/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.Activiti5Util;

public class TriggerCmd
extends NeedsActiveExecutionCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected final Map<String, Object> processVariables;

    public TriggerCmd(String executionId, Map<String, Object> processVariables) {
        super(executionId);
        this.processVariables = processVariables;
    }

    @Override
    protected Object execute(CommandContext commandContext, ExecutionEntity execution) {
        if (Activiti5Util.isActiviti5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
            activiti5CompatibilityHandler.trigger(this.executionId, this.processVariables);
            return null;
        }
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createSignalEvent(ActivitiEventType.ACTIVITY_SIGNALED, execution.getCurrentActivityId(), null, null, execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId()));
        commandContext.getAgenda().planTriggerExecutionOperation(execution);
        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot trigger an execution that is suspended";
    }
}

