/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.context;

import java.util.Stack;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.agenda.Agenda;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobExecutorContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<ProcessEngineConfigurationImpl>> processEngineConfigurationStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<ExecutionContext>> executionContextStackThreadLocal = new ThreadLocal();
    protected static ThreadLocal<JobExecutorContext> jobExecutorContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Activiti5CompatibilityHandler> activiti5CompatibilityHandlerThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Activiti5CompatibilityHandler> fallbackActiviti5CompatibilityHandlerThreadLocal = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)stack.peek();
    }

    public static Agenda getAgenda() {
        return Context.getCommandContext().getAgenda();
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push(commandContext);
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static ProcessEngineConfigurationImpl getProcessEngineConfiguration() {
        Stack stack = Context.getStack(processEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (ProcessEngineConfigurationImpl)stack.peek();
    }

    public static void setProcessEngineConfiguration(ProcessEngineConfigurationImpl processEngineConfiguration) {
        Context.getStack(processEngineConfigurationStackThreadLocal).push(processEngineConfiguration);
    }

    public static void removeProcessEngineConfiguration() {
        Context.getStack(processEngineConfigurationStackThreadLocal).pop();
    }

    public static ExecutionContext getExecutionContext() {
        return (ExecutionContext)Context.getStack(executionContextStackThreadLocal).peek();
    }

    public static boolean isExecutionContextActive() {
        Stack<ExecutionContext> stack = executionContextStackThreadLocal.get();
        return stack != null && !stack.isEmpty();
    }

    public static void setExecutionContext(ExecutionEntity execution) {
        Context.getStack(executionContextStackThreadLocal).push(new ExecutionContext(execution));
    }

    public static void removeExecutionContext() {
        Context.getStack(executionContextStackThreadLocal).pop();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }

    public static JobExecutorContext getJobExecutorContext() {
        return jobExecutorContextThreadLocal.get();
    }

    public static void setJobExecutorContext(JobExecutorContext jobExecutorContext) {
        jobExecutorContextThreadLocal.set(jobExecutorContext);
    }

    public static void removeJobExecutorContext() {
        jobExecutorContextThreadLocal.remove();
    }

    public static Activiti5CompatibilityHandler getActiviti5CompatibilityHandler() {
        return activiti5CompatibilityHandlerThreadLocal.get();
    }

    public static void setActiviti5CompatibilityHandler(Activiti5CompatibilityHandler activiti5CompatibilityHandler) {
        activiti5CompatibilityHandlerThreadLocal.set(activiti5CompatibilityHandler);
    }

    public static void removeActiviti5CompatibilityHandler() {
        activiti5CompatibilityHandlerThreadLocal.remove();
    }

    public static Activiti5CompatibilityHandler getFallbackActiviti5CompatibilityHandler() {
        return fallbackActiviti5CompatibilityHandlerThreadLocal.get();
    }

    public static void setFallbackActiviti5CompatibilityHandler(Activiti5CompatibilityHandler activiti5CompatibilityHandler) {
        fallbackActiviti5CompatibilityHandlerThreadLocal.set(activiti5CompatibilityHandler);
    }

    public static void removeFallbackActiviti5CompatibilityHandler() {
        fallbackActiviti5CompatibilityHandlerThreadLocal.remove();
    }
}

