/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.delegate.invocation.ExpressionGetInvocation;
import org.activiti.engine.impl.delegate.invocation.ExpressionSetInvocation;
import org.activiti.engine.impl.el.Expression;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ELException;
import org.activiti.engine.impl.javax.el.MethodNotFoundException;
import org.activiti.engine.impl.javax.el.PropertyNotFoundException;
import org.activiti.engine.impl.javax.el.ValueExpression;

public class JuelExpression
implements Expression {
    protected String expressionText;
    protected ValueExpression valueExpression;

    public JuelExpression(ValueExpression valueExpression, String expressionText) {
        this.valueExpression = valueExpression;
        this.expressionText = expressionText;
    }

    @Override
    public Object getValue(VariableScope variableScope) {
        ELContext elContext = Context.getProcessEngineConfiguration().getExpressionManager().getElContext(variableScope);
        try {
            ExpressionGetInvocation invocation = new ExpressionGetInvocation(this.valueExpression, elContext);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
            return invocation.getInvocationResult();
        }
        catch (PropertyNotFoundException pnfe) {
            throw new ActivitiException("Unknown property used in expression: " + this.expressionText, pnfe);
        }
        catch (MethodNotFoundException mnfe) {
            throw new ActivitiException("Unknown method used in expression: " + this.expressionText, mnfe);
        }
        catch (ELException ele) {
            throw new ActivitiException("Error while evaluating expression: " + this.expressionText, ele);
        }
        catch (Exception e) {
            throw new ActivitiException("Error while evaluating expression: " + this.expressionText, e);
        }
    }

    @Override
    public void setValue(Object value, VariableScope variableScope) {
        ELContext elContext = Context.getProcessEngineConfiguration().getExpressionManager().getElContext(variableScope);
        try {
            ExpressionSetInvocation invocation = new ExpressionSetInvocation(this.valueExpression, elContext, value);
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(invocation);
        }
        catch (Exception e) {
            throw new ActivitiException("Error while evaluating expression: " + this.expressionText, e);
        }
    }

    public String toString() {
        if (this.valueExpression != null) {
            return this.valueExpression.getExpressionString();
        }
        return super.toString();
    }

    @Override
    public String getExpressionText() {
        return this.expressionText;
    }
}

