/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.event;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.event.AbstractEventHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.util.ProcessInstanceUtil;
import org.activiti.engine.repository.ProcessDefinition;

public class SignalEventHandler
extends AbstractEventHandler {
    public static final String EVENT_HANDLER_TYPE = "signal";

    @Override
    public String getEventHandlerType() {
        return EVENT_HANDLER_TYPE;
    }

    @Override
    public void handleEvent(EventSubscriptionEntity eventSubscription, Object payload, CommandContext commandContext) {
        if (eventSubscription.getExecutionId() != null) {
            super.handleEvent(eventSubscription, payload, commandContext);
        } else if (eventSubscription.getProcessDefinitionId() != null) {
            String processDefinitionId = eventSubscription.getProcessDefinitionId();
            DeploymentManager deploymentCache = Context.getProcessEngineConfiguration().getDeploymentManager();
            ProcessDefinitionEntity processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("No process definition found for id '" + processDefinitionId + "'", ProcessDefinition.class);
            }
            Map variables = null;
            if (payload != null && payload instanceof Map) {
                variables = (Map)payload;
            }
            ProcessInstanceUtil.createAndStartProcessInstance(processDefinition, null, null, variables);
        } else {
            throw new ActivitiException("Invalid signal handling: no execution nor process definition set");
        }
    }
}

