/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.history.parse;

import java.util.HashSet;
import java.util.Set;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.EventGateway;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.ManualTask;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.ScriptTask;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.bpmn.model.Task;
import org.activiti.bpmn.model.ThrowEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.parse.BpmnParseHandler;

public class FlowNodeHistoryParseHandler
implements BpmnParseHandler {
    protected static final String ACTIVITY_INSTANCE_START_LISTENER = "org.activiti.engine.impl.history.handler.ActivityInstanceStartHandler";
    protected static final String ACTIVITI_INSTANCE_END_LISTENER = "org.activiti.engine.impl.history.handler.ActivityInstanceEndHandler";
    protected static Set<Class<? extends BaseElement>> supportedElementClasses = new HashSet<Class<? extends BaseElement>>();

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        return supportedElementClasses;
    }

    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        if (element instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)element;
            this.addExecutionListenerAtStart("end", ACTIVITY_INSTANCE_START_LISTENER, (FlowElement)boundaryEvent);
            this.addExecutionListenerAtEnd("end", ACTIVITI_INSTANCE_END_LISTENER, (FlowElement)boundaryEvent);
        } else {
            FlowElement flowElement = (FlowElement)element;
            this.addExecutionListenerAtStart("start", ACTIVITY_INSTANCE_START_LISTENER, flowElement);
            this.addExecutionListenerAtEnd("end", ACTIVITI_INSTANCE_END_LISTENER, flowElement);
        }
    }

    protected void addExecutionListenerAtStart(String event, String className, FlowElement element) {
        ActivitiListener listener = this.createActivitiListener(event, className);
        element.getExecutionListeners().add(0, listener);
    }

    protected void addExecutionListenerAtEnd(String event, String className, FlowElement element) {
        ActivitiListener listener = this.createActivitiListener(event, className);
        element.getExecutionListeners().add(listener);
    }

    protected ActivitiListener createActivitiListener(String event, String className) {
        ActivitiListener listener = new ActivitiListener();
        listener.setEvent(event);
        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
        listener.setImplementation(className);
        return listener;
    }

    static {
        supportedElementClasses.add(StartEvent.class);
        supportedElementClasses.add(EndEvent.class);
        supportedElementClasses.add(ThrowEvent.class);
        supportedElementClasses.add(BoundaryEvent.class);
        supportedElementClasses.add(IntermediateCatchEvent.class);
        supportedElementClasses.add(ExclusiveGateway.class);
        supportedElementClasses.add(InclusiveGateway.class);
        supportedElementClasses.add(ParallelGateway.class);
        supportedElementClasses.add(EventGateway.class);
        supportedElementClasses.add(Task.class);
        supportedElementClasses.add(ManualTask.class);
        supportedElementClasses.add(ReceiveTask.class);
        supportedElementClasses.add(ScriptTask.class);
        supportedElementClasses.add(ServiceTask.class);
        supportedElementClasses.add(BusinessRuleTask.class);
        supportedElementClasses.add(SendTask.class);
        supportedElementClasses.add(UserTask.class);
        supportedElementClasses.add(CallActivity.class);
        supportedElementClasses.add(SubProcess.class);
    }
}

