/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.activiti.engine.impl.cmd.AcquireJobsCmd;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.jobexecutor.AcquireJobsRunnable;
import org.activiti.engine.impl.jobexecutor.AcquireJobsRunnableImpl;
import org.activiti.engine.impl.jobexecutor.AcquiredJobs;
import org.activiti.engine.impl.jobexecutor.RejectedJobsHandler;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.runtime.ClockReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobExecutor {
    private static Logger log = LoggerFactory.getLogger(JobExecutor.class);
    protected String name = "JobExecutor[" + this.getClass().getName() + "]";
    protected CommandExecutor commandExecutor;
    protected Command<AcquiredJobs> acquireJobsCmd;
    protected AcquireJobsRunnable acquireJobsRunnable;
    protected RejectedJobsHandler rejectedJobsHandler;
    protected Thread jobAcquisitionThread;
    protected boolean isAutoActivate;
    protected boolean isActive;
    protected int maxJobsPerAcquisition = 1;
    protected long waitTimeInMillis = 5000L;
    protected String lockOwner = UUID.randomUUID().toString();
    protected int lockTimeInMillis = 300000;
    protected ClockReader clockReader;

    public void start() {
        if (this.isActive) {
            return;
        }
        log.info("Starting up the JobExecutor[{}].", (Object)this.getClass().getName());
        this.ensureInitialization();
        this.startExecutingJobs();
        this.isActive = true;
    }

    public synchronized void shutdown() {
        if (!this.isActive) {
            return;
        }
        log.info("Shutting down the JobExecutor[{}].", (Object)this.getClass().getName());
        this.acquireJobsRunnable.stop();
        this.stopExecutingJobs();
        this.ensureCleanup();
        this.isActive = false;
    }

    protected void ensureInitialization() {
        if (this.acquireJobsCmd == null) {
            this.acquireJobsCmd = new AcquireJobsCmd(this);
        }
        if (this.acquireJobsRunnable == null) {
            this.acquireJobsRunnable = new AcquireJobsRunnableImpl(this);
        }
    }

    protected void ensureCleanup() {
        this.acquireJobsCmd = null;
        this.acquireJobsRunnable = null;
    }

    public void jobWasAdded() {
        if (this.isActive) {
            this.acquireJobsRunnable.jobWasAdded();
        }
    }

    protected void startJobAcquisitionThread() {
        if (this.jobAcquisitionThread == null) {
            this.jobAcquisitionThread = new Thread(this.acquireJobsRunnable);
        }
        this.jobAcquisitionThread.start();
    }

    protected void stopJobAcquisitionThread() {
        try {
            this.jobAcquisitionThread.join();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for the job Acquisition thread to terminate", (Throwable)e);
        }
        this.jobAcquisitionThread = null;
    }

    public abstract void executeJobs(List<String> var1);

    protected abstract void startExecutingJobs();

    protected abstract void stopExecutingJobs();

    public void jobDone(JobEntity job) {
    }

    public void jobDone(String jobId) {
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public long getWaitTimeInMillis() {
        return this.waitTimeInMillis;
    }

    public void setWaitTimeInMillis(int waitTimeInMillis) {
        this.waitTimeInMillis = waitTimeInMillis;
    }

    public int getLockTimeInMillis() {
        return this.lockTimeInMillis;
    }

    public void setLockTimeInMillis(int lockTimeInMillis) {
        this.lockTimeInMillis = lockTimeInMillis;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public boolean isAutoActivate() {
        return this.isAutoActivate;
    }

    public void setCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public void setAutoActivate(boolean isAutoActivate) {
        this.isAutoActivate = isAutoActivate;
    }

    public int getMaxJobsPerAcquisition() {
        return this.maxJobsPerAcquisition;
    }

    public void setMaxJobsPerAcquisition(int maxJobsPerAcquisition) {
        this.maxJobsPerAcquisition = maxJobsPerAcquisition;
    }

    public String getName() {
        return this.name;
    }

    public Command<AcquiredJobs> getAcquireJobsCmd() {
        return this.acquireJobsCmd;
    }

    public void setAcquireJobsCmd(Command<AcquiredJobs> acquireJobsCmd) {
        this.acquireJobsCmd = acquireJobsCmd;
    }

    public AcquireJobsRunnable getAcquireJobsRunnable() {
        return this.acquireJobsRunnable;
    }

    public void setAcquireJobsRunnable(AcquireJobsRunnable acquireJobsRunnable) {
        this.acquireJobsRunnable = acquireJobsRunnable;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public RejectedJobsHandler getRejectedJobsHandler() {
        return this.rejectedJobsHandler;
    }

    public void setRejectedJobsHandler(RejectedJobsHandler rejectedJobsHandler) {
        this.rejectedJobsHandler = rejectedJobsHandler;
    }

    public Date getCurrentTime() {
        return this.clockReader.getCurrentTime();
    }

    public void setClockReader(ClockReader clockReader) {
        this.clockReader = clockReader;
    }
}

