/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.jobexecutor;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SubProcess;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;

public class TriggerTimerEventJobHandler
implements JobHandler {
    public static final String TYPE = "trigger-timer";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        commandContext.getAgenda().planTriggerExecutionOperation(execution);
        if (commandContext.getEventDispatcher().isEnabled()) {
            commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.TIMER_FIRED, job));
        }
        if (execution.getCurrentFlowElement() instanceof BoundaryEvent) {
            ArrayList<String> processedElements = new ArrayList<String>();
            this.dispatchExecutionTimeOut(job, execution, processedElements, commandContext);
        }
    }

    protected void dispatchExecutionTimeOut(JobEntity timerEntity, ExecutionEntity execution, List<String> processedElements, CommandContext commandContext) {
        block7: {
            ExecutionEntity subProcessInstance;
            block6: {
                FlowElement currentElement = execution.getCurrentFlowElement();
                if (!(currentElement instanceof BoundaryEvent)) break block6;
                BoundaryEvent boundaryEvent = (BoundaryEvent)execution.getCurrentFlowElement();
                if (!boundaryEvent.isCancelActivity() || boundaryEvent.getAttachedToRef() == null || processedElements.contains(boundaryEvent.getId())) break block7;
                processedElements.add(boundaryEvent.getId());
                ExecutionEntity parentExecution = execution.getParent();
                this.dispatchExecutionTimeOut(timerEntity, parentExecution, processedElements, commandContext);
                break block7;
            }
            if (execution.getCurrentFlowElement() instanceof FlowNode) {
                processedElements.add(execution.getCurrentActivityId());
                this.dispatchActivityTimeOut(timerEntity, (FlowNode)execution.getCurrentFlowElement(), execution, commandContext);
            }
            if (execution.getCurrentFlowElement() instanceof SubProcess) {
                for (ExecutionEntity subExecution : execution.getExecutions()) {
                    if (processedElements.contains(subExecution.getCurrentActivityId())) continue;
                    this.dispatchExecutionTimeOut(timerEntity, subExecution, processedElements, commandContext);
                }
            } else if (execution.getCurrentFlowElement() instanceof CallActivity && (subProcessInstance = commandContext.getExecutionEntityManager().findSubProcessInstanceBySuperExecutionId(execution.getId())) != null) {
                List<ExecutionEntity> childExecutions = subProcessInstance.getExecutions();
                for (ExecutionEntity subExecution : childExecutions) {
                    if (processedElements.contains(subExecution.getCurrentActivityId())) continue;
                    this.dispatchExecutionTimeOut(timerEntity, subExecution, processedElements, commandContext);
                }
            }
        }
    }

    protected void dispatchActivityTimeOut(JobEntity timerEntity, FlowNode flowNode, ExecutionEntity execution, CommandContext commandContext) {
        commandContext.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(flowNode.getId(), flowNode.getName(), execution.getId(), execution.getProcessInstanceId(), execution.getProcessDefinitionId(), this.parseActivityType(flowNode), flowNode.getBehavior().getClass().getCanonicalName(), timerEntity));
    }

    protected String parseActivityType(FlowNode flowNode) {
        String elementType = flowNode.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }
}

