/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.cache;

import org.activiti.engine.impl.db.Entity;

public class CachedEntity {
    protected Entity entity;
    protected Object originalPersistentState;

    public CachedEntity(Entity entity, boolean storeState) {
        this.entity = entity;
        if (storeState) {
            this.originalPersistentState = entity.getPersistentState();
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public Object getOriginalPersistentState() {
        return this.originalPersistentState;
    }

    public void setOriginalPersistentState(Object originalPersistentState) {
        this.originalPersistentState = originalPersistentState;
    }

    public boolean hasChanged() {
        return this.entity.getPersistentState() != null && !this.entity.getPersistentState().equals(this.originalPersistentState);
    }
}

