/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.impl.db.Entity;
import org.activiti.engine.impl.persistence.cache.CachedEntity;
import org.activiti.engine.impl.persistence.cache.EntityCache;

public class EntityCacheImpl
implements EntityCache {
    protected Map<Class<?>, Map<String, CachedEntity>> cachedObjects = new HashMap();

    @Override
    public CachedEntity put(Entity entity, boolean storeState) {
        Map<String, CachedEntity> classCache = this.cachedObjects.get(entity.getClass());
        if (classCache == null) {
            classCache = new HashMap<String, CachedEntity>();
            this.cachedObjects.put(entity.getClass(), classCache);
        }
        CachedEntity cachedObject = new CachedEntity(entity, storeState);
        classCache.put(entity.getId(), cachedObject);
        return cachedObject;
    }

    @Override
    public <T> T findInCache(Class<T> entityClass, String id) {
        CachedEntity cachedObject = null;
        Map<String, CachedEntity> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            cachedObject = classCache.get(id);
        }
        if (cachedObject != null) {
            return (T)cachedObject.getEntity();
        }
        return null;
    }

    @Override
    public void cacheRemove(Class<?> entityClass, String entityId) {
        Map<String, CachedEntity> classCache = this.cachedObjects.get(entityClass);
        if (classCache == null) {
            return;
        }
        classCache.remove(entityId);
    }

    @Override
    public <T> Collection<CachedEntity> findInCacheAsCachedObjects(Class<T> entityClass) {
        Map<String, CachedEntity> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            return classCache.values();
        }
        return null;
    }

    @Override
    public <T> List<T> findInCache(Class<T> entityClass) {
        Map<String, CachedEntity> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            ArrayList<Entity> entities = new ArrayList<Entity>(classCache.size());
            for (CachedEntity cachedObject : classCache.values()) {
                entities.add(cachedObject.getEntity());
            }
            return entities;
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Class<?>, Map<String, CachedEntity>> getAllCachedEntities() {
        return this.cachedObjects;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

