/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.deploy;

import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.Deployer;
import org.activiti.engine.impl.persistence.deploy.DeploymentCache;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.DeploymentEntityManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.repository.ProcessDefinition;

public class DeploymentManager {
    protected DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache;
    protected DeploymentCache<Object> knowledgeBaseCache;
    protected List<Deployer> deployers;

    public void deploy(DeploymentEntity deployment) {
        this.deploy(deployment, null);
    }

    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        for (Deployer deployer : this.deployers) {
            deployer.deploy(deployment, deploymentSettings);
        }
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionById(String processDefinitionId) {
        ProcessDefinitionEntity processDefinition;
        if (processDefinitionId == null) {
            throw new ActivitiIllegalArgumentException("Invalid process definition id : null");
        }
        ProcessDefinitionCacheEntry cacheEntry = this.processDefinitionCache.get(processDefinitionId);
        ProcessDefinitionEntity processDefinitionEntity = processDefinition = cacheEntry != null ? cacheEntry.getProcessDefinitionEntity() : null;
        if (processDefinition == null) {
            processDefinition = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().findById(processDefinitionId);
            if (processDefinition == null) {
                throw new ActivitiObjectNotFoundException("no deployed process definition found with id '" + processDefinitionId + "'", ProcessDefinition.class);
            }
            processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinitionEntity();
        }
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKey(String processDefinitionKey) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(processDefinitionKey);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("no processes deployed with key '" + processDefinitionKey + "'", ProcessDefinition.class);
        }
        processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinitionEntity();
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedLatestProcessDefinitionByKeyAndTenantId(String processDefinitionKey, String tenantId) {
        ProcessDefinitionEntity processDefinition = Context.getCommandContext().getProcessDefinitionEntityManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("no processes deployed with key '" + processDefinitionKey + "' for tenant identifier '" + tenantId + "'", ProcessDefinition.class);
        }
        processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinitionEntity();
        return processDefinition;
    }

    public ProcessDefinitionEntity findDeployedProcessDefinitionByKeyAndVersion(String processDefinitionKey, Integer processDefinitionVersion) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)Context.getCommandContext().getProcessDefinitionEntityManager().findProcessDefinitionByKeyAndVersion(processDefinitionKey, processDefinitionVersion);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("no processes deployed with key = '" + processDefinitionKey + "' and version = '" + processDefinitionVersion + "'", ProcessDefinition.class);
        }
        processDefinition = this.resolveProcessDefinition(processDefinition).getProcessDefinitionEntity();
        return processDefinition;
    }

    public ProcessDefinitionCacheEntry resolveProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String processDefinitionId = processDefinition.getId();
        String deploymentId = processDefinition.getDeploymentId();
        ProcessDefinitionCacheEntry cachedProcessDefinition = this.processDefinitionCache.get(processDefinitionId);
        if (cachedProcessDefinition == null) {
            DeploymentEntity deployment = (DeploymentEntity)Context.getCommandContext().getDeploymentEntityManager().findById(deploymentId);
            deployment.setNew(false);
            this.deploy(deployment, null);
            cachedProcessDefinition = this.processDefinitionCache.get(processDefinitionId);
            if (cachedProcessDefinition == null) {
                throw new ActivitiException("deployment '" + deploymentId + "' didn't put process definition '" + processDefinitionId + "' in the cache");
            }
        }
        return cachedProcessDefinition;
    }

    public void removeDeployment(String deploymentId, boolean cascade) {
        CommandContext commandContext = Context.getCommandContext();
        DeploymentEntityManager deploymentEntityManager = commandContext.getDeploymentEntityManager();
        DeploymentEntity deployment = (DeploymentEntity)deploymentEntityManager.findById(deploymentId);
        if (deployment == null) {
            throw new ActivitiObjectNotFoundException("Could not find a deployment with id '" + deploymentId + "'.", DeploymentEntity.class);
        }
        if (commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled() && "activiti-5".equals(deployment.getEngineVersion())) {
            commandContext.getProcessEngineConfiguration().getActiviti5CompatibilityHandler().deleteDeployment(deploymentId, cascade);
            return;
        }
        List processDefinitions = new ProcessDefinitionQueryImpl(commandContext).deploymentId(deploymentId).list();
        ActivitiEventDispatcher eventDispatcher = Context.getProcessEngineConfiguration().getEventDispatcher();
        for (ProcessDefinition processDefinition : processDefinitions) {
            if (!eventDispatcher.isEnabled()) continue;
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, processDefinition));
        }
        deploymentEntityManager.deleteDeployment(deploymentId, cascade);
        if (eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, deployment));
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            this.processDefinitionCache.remove(processDefinition.getId());
        }
    }

    public List<Deployer> getDeployers() {
        return this.deployers;
    }

    public void setDeployers(List<Deployer> deployers) {
        this.deployers = deployers;
    }

    public DeploymentCache<ProcessDefinitionCacheEntry> getProcessDefinitionCache() {
        return this.processDefinitionCache;
    }

    public void setProcessDefinitionCache(DeploymentCache<ProcessDefinitionCacheEntry> processDefinitionCache) {
        this.processDefinitionCache = processDefinitionCache;
    }

    public DeploymentCache<Object> getKnowledgeBaseCache() {
        return this.knowledgeBaseCache;
    }

    public void setKnowledgeBaseCache(DeploymentCache<Object> knowledgeBaseCache) {
        this.knowledgeBaseCache = knowledgeBaseCache;
    }
}

