/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.db.Entity;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.CachedEntityMatcher;
import org.activiti.engine.impl.persistence.cache.CachedEntity;
import org.activiti.engine.impl.persistence.entity.EntityManager;

public class AbstractEntityManager<EntityImpl extends Entity>
extends AbstractManager
implements EntityManager<EntityImpl> {
    public Class<EntityImpl> getManagedEntity() {
        throw new UnsupportedOperationException();
    }

    public List<Class<? extends EntityImpl>> getManagedEntitySubClasses() {
        return null;
    }

    @Override
    public void insert(EntityImpl entity) {
        this.insert(entity, true);
    }

    @Override
    public void insert(EntityImpl entity, boolean fireCreateEvent) {
        this.getDbSqlSession().insert((Entity)entity);
        ActivitiEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (fireCreateEvent && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, entity));
            eventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, entity));
        }
    }

    @Override
    public void delete(String id) {
        EntityImpl entity = this.findById(id);
        this.delete(entity);
    }

    @Override
    public void delete(EntityImpl entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(EntityImpl entity, boolean fireDeleteEvent) {
        this.getDbSqlSession().delete((Entity)entity);
        if (fireDeleteEvent && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, entity));
        }
    }

    @Override
    public EntityImpl findById(String entityId) {
        if (entityId == null) {
            throw new ActivitiIllegalArgumentException("Invalid entity id : null");
        }
        Entity cachedEntity = (Entity)this.getEntityCache().findInCache(this.getManagedEntity(), entityId);
        if (cachedEntity != null) {
            return (EntityImpl)cachedEntity;
        }
        return this.getDbSqlSession().selectById(this.getManagedEntity(), entityId);
    }

    @Override
    public EntityImpl findByQuery(String selectQuery, Object parameter, CachedEntityMatcher<EntityImpl> cachedEntityMatcher) {
        for (Entity cachedEntity : this.getEntityCache().findInCache(this.getManagedEntity())) {
            if (!cachedEntityMatcher.isRetained(cachedEntity)) continue;
            return (EntityImpl)cachedEntity;
        }
        return (EntityImpl)((Entity)this.getDbSqlSession().selectOne(selectQuery, parameter));
    }

    @Override
    public List<EntityImpl> getList(String dbQueryName, Object parameter, CachedEntityMatcher<EntityImpl> retainEntityCondition, boolean checkCache) {
        Collection<CachedEntity> cachedObjects;
        Collection<Object> result = this.getDbSqlSession().selectList(dbQueryName, parameter);
        if (checkCache && ((cachedObjects = this.getEntityCache().findInCacheAsCachedObjects(this.getManagedEntity())) != null && cachedObjects.size() > 0 || this.getManagedEntitySubClasses() != null)) {
            HashMap<String, Entity> entityMap = new HashMap<String, Entity>(result.size());
            for (Entity entity : result) {
                entityMap.put(entity.getId(), entity);
            }
            if (cachedObjects != null) {
                for (CachedEntity cachedEntity : cachedObjects) {
                    Entity cachedEntity2 = cachedEntity.getEntity();
                    if (!retainEntityCondition.isRetained(cachedEntity2)) continue;
                    entityMap.put(cachedEntity2.getId(), cachedEntity2);
                }
            }
            if (this.getManagedEntitySubClasses() != null) {
                for (Class clazz : this.getManagedEntitySubClasses()) {
                    Collection<CachedEntity> subclassCachedObjects = this.getEntityCache().findInCacheAsCachedObjects(clazz);
                    if (subclassCachedObjects == null) continue;
                    for (CachedEntity subclassCachedObject : subclassCachedObjects) {
                        Entity cachedSubclassEntity = subclassCachedObject.getEntity();
                        if (!retainEntityCondition.isRetained(cachedSubclassEntity)) continue;
                        entityMap.put(cachedSubclassEntity.getId(), cachedSubclassEntity);
                    }
                }
            }
            result = entityMap.values();
        }
        if (result.size() > 0) {
            Iterator resultIterator = result.iterator();
            while (resultIterator.hasNext()) {
                if (!this.getDbSqlSession().isEntityToBeDeleted((Entity)resultIterator.next())) continue;
                resultIterator.remove();
            }
        }
        return new ArrayList(result);
    }
}

