/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.AttachmentEntityManager;
import org.activiti.engine.task.Attachment;
import org.activiti.engine.task.Task;

public class AttachmentEntityManagerImpl
extends AbstractEntityManager<AttachmentEntity>
implements AttachmentEntityManager {
    @Override
    public Class<AttachmentEntity> getManagedEntity() {
        return AttachmentEntity.class;
    }

    @Override
    public List<Attachment> findAttachmentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectAttachmentsByProcessInstanceId", processInstanceId);
    }

    @Override
    public List<Attachment> findAttachmentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectAttachmentsByTaskId", taskId);
    }

    @Override
    public void deleteAttachmentsByTaskId(String taskId) {
        Task task;
        this.checkHistoryEnabled();
        List attachments = this.getDbSqlSession().selectList("selectAttachmentsByTaskId", taskId);
        boolean dispatchEvents = this.getEventDispatcher().isEnabled();
        String processInstanceId = null;
        String processDefinitionId = null;
        String executionId = null;
        if (dispatchEvents && attachments != null && !attachments.isEmpty() && (task = (Task)this.getTaskEntityManager().findById(taskId)) != null) {
            processDefinitionId = task.getProcessDefinitionId();
            processInstanceId = task.getProcessInstanceId();
            executionId = task.getExecutionId();
        }
        for (AttachmentEntity attachment : attachments) {
            String contentId = attachment.getContentId();
            if (contentId != null) {
                this.getByteArrayEntityManager().deleteByteArrayById(contentId);
            }
            this.getDbSqlSession().delete(attachment);
            if (!dispatchEvents) continue;
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, attachment, executionId, processInstanceId, processDefinitionId));
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new ActivitiException("In order to use attachments, history should be enabled");
        }
    }
}

