/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.Arrays;
import org.activiti.engine.impl.db.Entity;
import org.activiti.engine.impl.db.HasRevision;
import org.apache.commons.lang3.StringUtils;

public class ByteArrayEntity
implements Serializable,
Entity,
HasRevision {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String name;
    protected byte[] bytes;
    protected String deploymentId;

    protected ByteArrayEntity() {
    }

    public ByteArrayEntity(String name, byte[] bytes) {
        this.name = name;
        this.bytes = bytes;
    }

    public ByteArrayEntity(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public Object getPersistentState() {
        return new PersistentState(this.name, this.bytes);
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String toString() {
        return "ByteArrayEntity[id=" + this.id + ", name=" + this.name + ", size=" + (this.bytes != null ? this.bytes.length : 0) + "]";
    }

    private static class PersistentState {
        private final String name;
        private final byte[] bytes;

        public PersistentState(String name, byte[] bytes) {
            this.name = name;
            this.bytes = bytes;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PersistentState) {
                PersistentState other = (PersistentState)obj;
                return StringUtils.equals((CharSequence)this.name, (CharSequence)other.name) && Arrays.equals(this.bytes, other.bytes);
            }
            return false;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

