/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.CommentEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Event;

public class CommentEntityManagerImpl
extends AbstractEntityManager<CommentEntity>
implements CommentEntityManager {
    @Override
    public Class<CommentEntity> getManagedEntity() {
        return CommentEntity.class;
    }

    @Override
    public void insert(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        super.insert(commentEntity, false);
        CommentEntity comment = commentEntity;
        if (this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, commentEntity, processInstanceId, processInstanceId, processDefinitionId));
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, commentEntity, processInstanceId, processInstanceId, processDefinitionId));
        }
    }

    @Override
    public List<Comment> findCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectCommentsByTaskId", taskId);
    }

    @Override
    public List<Comment> findCommentsByTaskIdAndType(String taskId, String type) {
        this.checkHistoryEnabled();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        params.put("type", type);
        return this.getDbSqlSession().selectListWithRawParameter("selectCommentsByTaskIdAndType", params, 0, Integer.MAX_VALUE);
    }

    @Override
    public List<Comment> findCommentsByType(String type) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectCommentsByType", type);
    }

    @Override
    public List<Event> findEventsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectEventsByTaskId", taskId);
    }

    @Override
    public List<Event> findEventsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectEventsByProcessInstanceId", processInstanceId);
    }

    @Override
    public void deleteCommentsByTaskId(String taskId) {
        this.checkHistoryEnabled();
        this.getDbSqlSession().delete("deleteCommentsByTaskId", taskId);
    }

    @Override
    public void deleteCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        this.getDbSqlSession().delete("deleteCommentsByProcessInstanceId", processInstanceId);
    }

    @Override
    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId) {
        this.checkHistoryEnabled();
        return this.getDbSqlSession().selectList("selectCommentsByProcessInstanceId", processInstanceId);
    }

    @Override
    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId, String type) {
        this.checkHistoryEnabled();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        params.put("type", type);
        return this.getDbSqlSession().selectListWithRawParameter("selectCommentsByProcessInstanceIdAndType", params, 0, Integer.MAX_VALUE);
    }

    @Override
    public Comment findComment(String commentId) {
        return this.getDbSqlSession().selectById(CommentEntity.class, commentId);
    }

    @Override
    public Event findEvent(String commentId) {
        return this.getDbSqlSession().selectById(CommentEntity.class, commentId);
    }

    @Override
    public void delete(CommentEntity commentEntity) {
        this.checkHistoryEnabled();
        super.delete(commentEntity, false);
        CommentEntity comment = commentEntity;
        if (this.getEventDispatcher().isEnabled()) {
            ExecutionEntity process;
            String processDefinitionId = null;
            String processInstanceId = comment.getProcessInstanceId();
            if (comment.getProcessInstanceId() != null && (process = (ExecutionEntity)this.getExecutionEntityManager().findById(comment.getProcessInstanceId())) != null) {
                processDefinitionId = process.getProcessDefinitionId();
            }
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, commentEntity, processInstanceId, processInstanceId, processDefinitionId));
        }
    }

    protected void checkHistoryEnabled() {
        if (!this.getHistoryManager().isHistoryEnabled()) {
            throw new ActivitiException("In order to use comments, history should be enabled");
        }
    }
}

