/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.DeploymentQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.DeploymentEntityManager;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.TimerUtil;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Job;
import org.apache.commons.collections.CollectionUtils;

public class DeploymentEntityManagerImpl
extends AbstractEntityManager<DeploymentEntity>
implements DeploymentEntityManager {
    @Override
    public Class<DeploymentEntity> getManagedEntity() {
        return DeploymentEntity.class;
    }

    @Override
    public void insert(DeploymentEntity deployment) {
        this.getDbSqlSession().insert(deployment);
        for (ResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId, boolean cascade) {
        String processDefinitionId;
        List processDefinitions = this.getDbSqlSession().createProcessDefinitionQuery().deploymentId(deploymentId).list();
        List models = this.getDbSqlSession().createModelQueryImpl().deploymentId(deploymentId).list();
        for (Model model : models) {
            ModelEntity modelEntity = (ModelEntity)model;
            modelEntity.setDeploymentId(null);
            this.getModelEntityManager().updateModel(modelEntity);
        }
        if (cascade) {
            for (ProcessDefinition processDefinition : processDefinitions) {
                processDefinitionId = processDefinition.getId();
                this.getExecutionEntityManager().deleteProcessInstancesByProcessDefinition(processDefinitionId, "deleted deployment", cascade);
            }
        }
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionId = processDefinition.getId();
            this.getIdentityLinkEntityManager().deleteIdentityLinksByProcDef(processDefinitionId);
            this.getEventSubscriptionEntityManager().deleteEventSubscriptionsForProcessDefinition(processDefinitionId);
        }
        this.getProcessDefinitionEntityManager().deleteProcessDefinitionsByDeploymentId(deploymentId);
        for (ProcessDefinition processDefinition : processDefinitions) {
            List startEvents;
            Process previousProcess;
            List<Job> timerStartJobs = this.getJobEntityManager().findJobsByTypeAndProcessDefinitionId("timer-start-event", processDefinition.getId());
            if (timerStartJobs != null && timerStartJobs.size() > 0) {
                for (Job timerStartJob : timerStartJobs) {
                    if (this.getEventDispatcher().isEnabled()) {
                        this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, timerStartJob, null, null, processDefinition.getId()));
                    }
                    this.getJobEntityManager().delete((JobEntity)timerStartJob);
                }
            }
            ProcessDefinitionEntity latestProcessDefinition = null;
            latestProcessDefinition = processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId()) ? this.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKeyAndTenantId(processDefinition.getKey(), processDefinition.getTenantId()) : this.getProcessDefinitionEntityManager().findLatestProcessDefinitionByKey(processDefinition.getKey());
            if (!processDefinition.getId().equals(latestProcessDefinition.getId())) continue;
            ProcessDefinitionEntity previousProcessDefinition = null;
            for (int previousVersion = processDefinition.getVersion() - 1; previousProcessDefinition == null && previousVersion > 0; --previousVersion) {
                ProcessDefinitionQueryImpl previousProcessDefinitionQuery = new ProcessDefinitionQueryImpl(this.getCommandContext()).processDefinitionVersion(previousVersion).processDefinitionKey(processDefinition.getKey());
                if (processDefinition.getTenantId() != null && !"".equals(processDefinition.getTenantId())) {
                    previousProcessDefinitionQuery.processDefinitionTenantId(processDefinition.getTenantId());
                } else {
                    previousProcessDefinitionQuery.processDefinitionWithoutTenantId();
                }
                previousProcessDefinition = (ProcessDefinitionEntity)previousProcessDefinitionQuery.singleResult();
            }
            if (previousProcessDefinition == null || !CollectionUtils.isNotEmpty((Collection)(previousProcess = ProcessDefinitionUtil.getProcess(previousProcessDefinition.getId())).getFlowElements()) || !CollectionUtils.isNotEmpty((Collection)(startEvents = previousProcess.findFlowElementsOfType(StartEvent.class)))) continue;
            for (StartEvent startEvent : startEvents) {
                EventDefinition eventDefinition;
                if (!CollectionUtils.isNotEmpty((Collection)startEvent.getEventDefinitions()) || !((eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0)) instanceof TimerEventDefinition)) continue;
                TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
                TimerEntity timer = TimerUtil.createTimerEntityForTimerEventDefinition((TimerEventDefinition)eventDefinition, false, null, "timer-start-event", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate()));
                if (timer == null) continue;
                timer.setProcessDefinitionId(previousProcessDefinition.getId());
                if (previousProcessDefinition.getTenantId() != null) {
                    timer.setTenantId(previousProcessDefinition.getTenantId());
                }
                this.getJobEntityManager().schedule(timer);
            }
        }
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.getDbSqlSession().delete("deleteDeployment", deploymentId);
    }

    @Override
    public DeploymentEntity findLatestDeploymentByName(String deploymentName) {
        List list = this.getDbSqlSession().selectList("selectDeploymentsByName", deploymentName, 0, 1);
        if (list != null && !list.isEmpty()) {
            return (DeploymentEntity)list.get(0);
        }
        return null;
    }

    @Override
    public long findDeploymentCountByQueryCriteria(DeploymentQueryImpl deploymentQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByQueryCriteria", deploymentQuery);
    }

    @Override
    public List<Deployment> findDeploymentsByQueryCriteria(DeploymentQueryImpl deploymentQuery, Page page) {
        String query = "selectDeploymentsByQueryCriteria";
        return this.getDbSqlSession().selectList("selectDeploymentsByQueryCriteria", deploymentQuery, page);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.getDbSqlSession().getSqlSession().selectList("selectResourceNamesByDeploymentId", (Object)deploymentId);
    }

    @Override
    public List<Deployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectDeploymentByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectDeploymentCountByNativeQuery", parameterMap);
    }
}

