/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.EventSubscriptionQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.event.EventHandler;
import org.activiti.engine.impl.persistence.CachedEntityMatcher;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.apache.commons.lang3.StringUtils;

public class EventSubscriptionEntityManagerImpl
extends AbstractEntityManager<EventSubscriptionEntity>
implements EventSubscriptionEntityManager {
    private static final List<Class<? extends EventSubscriptionEntity>> ENTITY_SUBCLASSES = Arrays.asList(MessageEventSubscriptionEntity.class, SignalEventSubscriptionEntity.class, CompensateEventSubscriptionEntity.class);

    @Override
    public Class<EventSubscriptionEntity> getManagedEntity() {
        return EventSubscriptionEntity.class;
    }

    @Override
    public List<Class<? extends EventSubscriptionEntity>> getManagedEntitySubClasses() {
        return ENTITY_SUBCLASSES;
    }

    @Override
    public void insert(EventSubscriptionEntity eventSubScriptionEntity) {
        super.insert(eventSubScriptionEntity);
        this.addToExecution(eventSubScriptionEntity);
    }

    @Override
    public SignalEventSubscriptionEntity insertSignalEvent(SignalEventDefinition signalEventDefinition, Signal signal, ExecutionEntity execution) {
        SignalEventSubscriptionEntity subscriptionEntity = new SignalEventSubscriptionEntity();
        subscriptionEntity.setExecution(execution);
        if (signal != null) {
            subscriptionEntity.setEventName(signal.getName());
            if (signal.getScope() != null) {
                subscriptionEntity.setConfiguration(signal.getScope());
            }
        } else {
            subscriptionEntity.setEventName(signalEventDefinition.getSignalRef());
        }
        subscriptionEntity.setActivityId(execution.getCurrentActivityId());
        subscriptionEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        if (execution.getTenantId() != null) {
            subscriptionEntity.setTenantId(execution.getTenantId());
        }
        this.insert(subscriptionEntity);
        execution.getEventSubscriptions().add(subscriptionEntity);
        return subscriptionEntity;
    }

    @Override
    public MessageEventSubscriptionEntity insertMessageEvent(MessageEventDefinition messageEventDefinition, ExecutionEntity execution) {
        MessageEventSubscriptionEntity subscriptionEntity = new MessageEventSubscriptionEntity();
        subscriptionEntity.setExecution(execution);
        subscriptionEntity.setEventName(messageEventDefinition.getMessageRef());
        subscriptionEntity.setActivityId(execution.getCurrentActivityId());
        subscriptionEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        if (execution.getTenantId() != null) {
            subscriptionEntity.setTenantId(execution.getTenantId());
        }
        this.insert(subscriptionEntity);
        execution.getEventSubscriptions().add(subscriptionEntity);
        return subscriptionEntity;
    }

    @Override
    public CompensateEventSubscriptionEntity insertCompensationEvent(ExecutionEntity execution, String activityId) {
        CompensateEventSubscriptionEntity eventSubscription = new CompensateEventSubscriptionEntity();
        eventSubscription.setExecution(execution);
        eventSubscription.setActivityId(activityId);
        if (execution.getTenantId() != null) {
            eventSubscription.setTenantId(execution.getTenantId());
        }
        this.insert(eventSubscription);
        return eventSubscription;
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByExecutionId(String executionId) {
        return this.findCompensateEventSubscriptionsByExecutionIdAndActivityId(executionId, null);
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByExecutionIdAndActivityId(String executionId, String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.findEventSubscriptionsByExecutionAndType(executionId, "compensate");
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            if (!(eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) || activityId != null && !activityId.equals(eventSubscriptionEntity.getActivityId())) continue;
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    @Override
    public List<CompensateEventSubscriptionEntity> findCompensateEventSubscriptionsByProcessInstanceIdAndActivityId(String processInstanceId, String activityId) {
        List<EventSubscriptionEntity> eventSubscriptions = this.findEventSubscriptionsByProcessInstanceAndActivityId(processInstanceId, activityId, "compensate");
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>();
        for (EventSubscriptionEntity eventSubscriptionEntity : eventSubscriptions) {
            result.add((CompensateEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return result;
    }

    protected void addToExecution(EventSubscriptionEntity eventSubscriptionEntity) {
        ExecutionEntity execution = eventSubscriptionEntity.getExecution();
        if (execution != null) {
            execution.getEventSubscriptions().add(eventSubscriptionEntity);
        }
    }

    @Override
    public long findEventSubscriptionCountByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl) {
        String query = "selectEventSubscriptionCountByQueryCriteria";
        return (Long)this.getDbSqlSession().selectOne("selectEventSubscriptionCountByQueryCriteria", eventSubscriptionQueryImpl);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByQueryCriteria(EventSubscriptionQueryImpl eventSubscriptionQueryImpl, Page page) {
        String query = "selectEventSubscriptionByQueryCriteria";
        return this.getDbSqlSession().selectList("selectEventSubscriptionByQueryCriteria", eventSubscriptionQueryImpl, page);
    }

    @Override
    public List<MessageEventSubscriptionEntity> findMessageEventSubscriptionsByProcessInstanceAndEventName(final String processInstanceId, final String eventName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        params.put("eventName", eventName);
        return this.toMessageEventSubscriptionEntityList(this.getList("selectMessageEventSubscriptionsByProcessInstanceAndEventName", params, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                return eventSubscriptionEntity.getEventType() != null && eventSubscriptionEntity.getEventType().equals("message") && eventSubscriptionEntity.getEventName() != null && eventSubscriptionEntity.getEventName().equals(eventName) && eventSubscriptionEntity.getProcessInstanceId() != null && eventSubscriptionEntity.getProcessInstanceId().equals(processInstanceId);
            }
        }, true));
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByEventName(final String eventName, final String tenantId) {
        String query = "selectSignalEventSubscriptionsByEventName";
        final HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventName", eventName);
        if (tenantId != null && !tenantId.equals("")) {
            params.put("tenantId", tenantId);
        }
        List<EventSubscriptionEntity> result = this.getList("selectSignalEventSubscriptionsByEventName", params, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                return eventSubscriptionEntity.getEventType() != null && eventSubscriptionEntity.getEventType().equals("signal") && eventSubscriptionEntity.getEventName() != null && eventSubscriptionEntity.getEventName().equals(eventName) && (eventSubscriptionEntity.getExecutionId() == null || eventSubscriptionEntity.getExecutionId() != null && eventSubscriptionEntity.getExecution() != null && eventSubscriptionEntity.getExecution().getSuspensionState() == SuspensionState.ACTIVE.getStateCode()) && (params.containsKey("tenantId") && tenantId.equals(eventSubscriptionEntity.getTenantId()) || !params.containsKey("tenantId") && StringUtils.isEmpty((CharSequence)eventSubscriptionEntity.getTenantId()));
            }
        }, true);
        return this.toSignalEventSubscriptionEntityList(result);
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByProcessInstanceAndEventName(final String processInstanceId, final String eventName) {
        String query = "selectSignalEventSubscriptionsByProcessInstanceAndEventName";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        params.put("eventName", eventName);
        return this.toSignalEventSubscriptionEntityList(this.getList("selectSignalEventSubscriptionsByProcessInstanceAndEventName", params, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                return eventSubscriptionEntity.getEventType() != null && eventSubscriptionEntity.getEventType().equals("signal") && eventSubscriptionEntity.getEventName() != null && eventSubscriptionEntity.getEventName().equals(eventName) && eventSubscriptionEntity.getProcessInstanceId() != null && eventSubscriptionEntity.getProcessInstanceId().equals(processInstanceId);
            }
        }, true));
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByExecution(final String executionId) {
        return this.toSignalEventSubscriptionEntityList(this.getList("selectSignalEventSubscriptionsByExecution", executionId, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                return eventSubscriptionEntity.getEventType() != null && eventSubscriptionEntity.getEventType().equals("signal") && eventSubscriptionEntity.getExecutionId() != null && eventSubscriptionEntity.getExecutionId().equals(executionId);
            }
        }, true));
    }

    @Override
    public List<SignalEventSubscriptionEntity> findSignalEventSubscriptionsByNameAndExecution(final String name, final String executionId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        params.put("eventName", name);
        return this.toSignalEventSubscriptionEntityList(this.getList("selectSignalEventSubscriptionsByNameAndExecution", params, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                return eventSubscriptionEntity.getEventType() != null && eventSubscriptionEntity.getEventType().equals("signal") && eventSubscriptionEntity.getExecutionId() != null && eventSubscriptionEntity.getExecutionId().equals(executionId) && eventSubscriptionEntity.getEventName() != null && eventSubscriptionEntity.getEventName().equals(name);
            }
        }, true));
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByExecutionAndType(final String executionId, final String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("executionId", executionId);
        params.put("eventType", type);
        return this.getList("selectEventSubscriptionsByExecutionAndType", params, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                return eventSubscriptionEntity.getEventType() != null && eventSubscriptionEntity.getEventType().equals(type) && eventSubscriptionEntity.getExecutionId() != null && eventSubscriptionEntity.getExecutionId().equals(executionId);
            }
        }, true);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByProcessInstanceAndActivityId(final String processInstanceId, final String activityId, final String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        params.put("eventType", type);
        params.put("activityId", activityId);
        return this.getList("selectEventSubscriptionsByProcessInstanceTypeAndActivity", params, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                return eventSubscriptionEntity.getEventType() != null && eventSubscriptionEntity.getEventType().equals(type) && eventSubscriptionEntity.getProcessInstanceId() != null && eventSubscriptionEntity.getProcessInstanceId().equals(processInstanceId) && eventSubscriptionEntity.getActivityId() != null && eventSubscriptionEntity.getActivityId().equals(activityId);
            }
        }, true);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByExecution(final String executionId) {
        return this.getList("selectEventSubscriptionsByExecution", executionId, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                return eventSubscriptionEntity.getExecutionId() != null && eventSubscriptionEntity.getExecutionId().equals(executionId);
            }
        }, true);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByConfiguration(String type, String configuration, String tenantId) {
        String query = "selectEventSubscriptionsByConfiguration";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventType", type);
        params.put("configuration", configuration);
        if (tenantId != null && !tenantId.equals("")) {
            params.put("tenantId", tenantId);
        }
        return this.getDbSqlSession().selectList("selectEventSubscriptionsByConfiguration", params);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByName(final String type, final String eventName, final String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventType", type);
        params.put("eventName", eventName);
        if (tenantId != null && !tenantId.equals("")) {
            params.put("tenantId", tenantId);
        }
        return this.getList("selectEventSubscriptionsByName", params, new CachedEntityMatcher<EventSubscriptionEntity>(){

            @Override
            public boolean isRetained(EventSubscriptionEntity eventSubscriptionEntity) {
                if (eventSubscriptionEntity.getEventType() != null && eventSubscriptionEntity.getEventType().equals(type) && eventSubscriptionEntity.getEventName() != null && eventSubscriptionEntity.getEventName().equals(eventName)) {
                    if (tenantId != null && !tenantId.equals("")) {
                        return eventSubscriptionEntity.getTenantId() != null && eventSubscriptionEntity.getTenantId().equals(tenantId);
                    }
                    return "".equals(eventSubscriptionEntity.getTenantId()) || eventSubscriptionEntity.getTenantId() == null;
                }
                return false;
            }
        }, true);
    }

    @Override
    public List<EventSubscriptionEntity> findEventSubscriptionsByNameAndExecution(String type, String eventName, String executionId) {
        String query = "selectEventSubscriptionsByNameAndExecution";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventType", type);
        params.put("eventName", eventName);
        params.put("executionId", executionId);
        return this.getDbSqlSession().selectList("selectEventSubscriptionsByNameAndExecution", params);
    }

    @Override
    public MessageEventSubscriptionEntity findMessageStartEventSubscriptionByName(String messageName, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("eventName", messageName);
        if (tenantId != null && !tenantId.equals("")) {
            params.put("tenantId", tenantId);
        }
        MessageEventSubscriptionEntity entity = (MessageEventSubscriptionEntity)this.getDbSqlSession().selectOne("selectMessageStartEventSubscriptionByName", params);
        return entity;
    }

    @Override
    public void updateEventSubscriptionTenantId(String oldTenantId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oldTenantId", oldTenantId);
        params.put("newTenantId", newTenantId);
        this.getDbSqlSession().update("updateTenantIdOfEventSubscriptions", params);
    }

    @Override
    public void eventReceived(EventSubscriptionEntity eventSubscriptionEntity, Object payload, boolean processASync) {
        if (processASync) {
            this.scheduleEventAsync(eventSubscriptionEntity, payload);
        } else {
            this.processEventSync(eventSubscriptionEntity, payload);
        }
    }

    protected void processEventSync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        EventHandler eventHandler;
        if (eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) {
            this.delete(eventSubscriptionEntity);
        }
        if ((eventHandler = this.getProcessEngineConfiguration().getEventHandler(eventSubscriptionEntity.getEventType())) == null) {
            throw new ActivitiException("Could not find eventhandler for event of type '" + eventSubscriptionEntity.getEventType() + "'.");
        }
        eventHandler.handleEvent(eventSubscriptionEntity, payload, this.getCommandContext());
    }

    protected void scheduleEventAsync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        MessageEntity message = new MessageEntity();
        message.setJobHandlerType("event");
        message.setJobHandlerConfiguration(eventSubscriptionEntity.getId());
        message.setTenantId(eventSubscriptionEntity.getTenantId());
        GregorianCalendar expireCal = new GregorianCalendar();
        ProcessEngineConfigurationImpl processEngineConfig = this.getProcessEngineConfiguration();
        expireCal.setTime(processEngineConfig.getClock().getCurrentTime());
        expireCal.add(13, processEngineConfig.getLockTimeAsyncJobWaitTime());
        message.setLockExpirationTime(expireCal.getTime());
        this.getJobEntityManager().send(message);
    }

    @Override
    public void deleteEventSubscriptionsForProcessDefinition(String processDefinitionId) {
        this.getDbSqlSession().delete("deleteEventSubscriptionsForProcessDefinition", processDefinitionId);
    }

    protected List<SignalEventSubscriptionEntity> toSignalEventSubscriptionEntityList(List<EventSubscriptionEntity> result) {
        ArrayList<SignalEventSubscriptionEntity> signalEventSubscriptionEntities = new ArrayList<SignalEventSubscriptionEntity>(result.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : result) {
            signalEventSubscriptionEntities.add((SignalEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return signalEventSubscriptionEntities;
    }

    protected List<MessageEventSubscriptionEntity> toMessageEventSubscriptionEntityList(List<EventSubscriptionEntity> result) {
        ArrayList<MessageEventSubscriptionEntity> messageEventSubscriptionEntities = new ArrayList<MessageEventSubscriptionEntity>(result.size());
        for (EventSubscriptionEntity eventSubscriptionEntity : result) {
            messageEventSubscriptionEntities.add((MessageEventSubscriptionEntity)eventSubscriptionEntity);
        }
        return messageEventSubscriptionEntities;
    }
}

