/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.ExecutionQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessInstanceQueryImpl;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.CachedEntityMatcher;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntityManager;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.JobEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntityManager;
import org.activiti.engine.impl.util.tree.ExecutionTree;
import org.activiti.engine.impl.util.tree.ExecutionTreeBfsIterator;
import org.activiti.engine.impl.util.tree.ExecutionTreeNode;
import org.activiti.engine.impl.util.tree.ExecutionTreeUtil;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEntityManagerImpl
extends AbstractEntityManager<ExecutionEntity>
implements ExecutionEntityManager {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEntityManagerImpl.class);

    @Override
    public Class<ExecutionEntity> getManagedEntity() {
        return ExecutionEntity.class;
    }

    @Override
    public ExecutionEntity findSubProcessInstanceBySuperExecutionId(final String superExecutionId) {
        return this.findByQuery("selectSubProcessInstanceBySuperExecutionId", superExecutionId, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity executionEntity) {
                return executionEntity.getSuperExecutionId() != null && superExecutionId.equals(executionEntity.getSuperExecutionId());
            }
        });
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByParentExecutionId(final String parentExecutionId) {
        return this.getList("selectExecutionsByParentExecutionId", parentExecutionId, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity entity) {
                return entity.getParentId() != null && entity.getParentId().equals(parentExecutionId);
            }
        }, true);
    }

    @Override
    public List<ExecutionEntity> findChildExecutionsByProcessInstanceId(final String processInstanceId) {
        return this.getList("selectChildExecutionsByProcessInstanceId", processInstanceId, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity executionEntity) {
                return executionEntity.getProcessInstanceId() != null && executionEntity.getProcessInstanceId().equals(processInstanceId) && executionEntity.getParentId() != null;
            }
        }, true);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByParentExecutionAndActivityIds(final String parentExecutionId, final Collection<String> activityIds) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("parentExecutionId", parentExecutionId);
        parameters.put("activityIds", activityIds);
        return this.getList("selectExecutionsByParentExecutionAndActivityIds", parameters, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity executionEntity) {
                return executionEntity.getParentId() != null && executionEntity.getParentId().equals(parentExecutionId) && executionEntity.getActivityId() != null && activityIds.contains(executionEntity.getActivityId());
            }
        }, true);
    }

    @Override
    public long findExecutionCountByQueryCriteria(ExecutionQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByQueryCriteria", executionQuery);
    }

    @Override
    public List<ExecutionEntity> findExecutionsByQueryCriteria(ExecutionQueryImpl executionQuery, Page page) {
        return this.getDbSqlSession().selectList("selectExecutionsByQueryCriteria", executionQuery, page);
    }

    @Override
    public long findProcessInstanceCountByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectProcessInstanceCountByQueryCriteria", executionQuery);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        return this.getDbSqlSession().selectList("selectProcessInstanceByQueryCriteria", executionQuery);
    }

    @Override
    public ExecutionTree findExecutionTree(final String rootProcessInstanceId) {
        List<ExecutionEntity> executions = this.getList("selectExecutionsByRootProcessInstanceId", rootProcessInstanceId, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity entity) {
                return entity.getRootProcessInstanceId() != null && entity.getRootProcessInstanceId().equals(rootProcessInstanceId);
            }
        }, true);
        return ExecutionTreeUtil.buildExecutionTree(executions);
    }

    protected ExecutionTree findExecutionTreeInCurrentProcessInstance(final String processInstanceId) {
        List<ExecutionEntity> executions = this.getList("selectExecutionsByProcessInstanceId", processInstanceId, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity entity) {
                return entity.getProcessInstanceId() != null && entity.getProcessInstanceId().equals(processInstanceId);
            }
        }, true);
        return ExecutionTreeUtil.buildExecutionTreeForProcessInstance(executions);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceAndVariablesByQueryCriteria(ProcessInstanceQueryImpl executionQuery) {
        if (executionQuery.getFirstResult() < 0 || executionQuery.getMaxResults() <= 0) {
            return Collections.EMPTY_LIST;
        }
        int firstResult = executionQuery.getFirstResult();
        int maxResults = executionQuery.getMaxResults();
        executionQuery.setMaxResults(20000);
        executionQuery.setFirstResult(0);
        List instanceList = this.getDbSqlSession().selectListWithRawParameterWithoutFilter("selectProcessInstanceWithVariablesByQueryCriteria", executionQuery, executionQuery.getFirstResult(), executionQuery.getMaxResults());
        if (instanceList != null && !instanceList.isEmpty()) {
            if (firstResult > 0) {
                if (firstResult <= instanceList.size()) {
                    int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                    return instanceList.subList(firstResult, toIndex);
                }
                return Collections.EMPTY_LIST;
            }
            int toIndex = Math.min(maxResults, instanceList.size());
            return instanceList.subList(0, toIndex);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<ExecutionEntity> findEventScopeExecutionsByActivityId(String activityRef, String parentExecutionId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityId", activityRef);
        parameters.put("parentExecutionId", parentExecutionId);
        return this.getDbSqlSession().selectList("selectExecutionsByParentExecutionId", parameters);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByActivityId(final String activityId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("activityId", activityId);
        params.put("isActive", false);
        return this.getList("selectInactiveExecutionsInActivity", params, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity entity) {
                return !entity.isActive() && entity.getActivityId() != null && entity.getActivityId().equals(activityId);
            }
        }, true);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByProcessInstanceId(final String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("processInstanceId", processInstanceId);
        params.put("isActive", false);
        return this.getList("selectInactiveExecutionsForProcessInstance", params, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity executionEntity) {
                return executionEntity.getProcessInstanceId() != null && executionEntity.getProcessInstanceId().equals(processInstanceId) && !executionEntity.isActive();
            }
        }, true);
    }

    @Override
    public Collection<ExecutionEntity> findInactiveExecutionsByActivityIdAndProcessInstanceId(final String activityId, final String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("activityId", activityId);
        params.put("processInstanceId", processInstanceId);
        params.put("isActive", false);
        return this.getList("selectInactiveExecutionsInActivityAndProcessInstance", params, new CachedEntityMatcher<ExecutionEntity>(){

            @Override
            public boolean isRetained(ExecutionEntity executionEntity) {
                return executionEntity.getProcessInstanceId() != null && executionEntity.getProcessInstanceId().equals(processInstanceId) && !executionEntity.isActive() && executionEntity.getActivityId() != null && executionEntity.getActivityId().equals(activityId);
            }
        }, true);
    }

    @Override
    public List<Execution> findExecutionsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public List<ProcessInstance> findProcessInstanceByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectExecutionByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findExecutionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectExecutionCountByNativeQuery", parameterMap);
    }

    @Override
    public ExecutionEntity createProcessInstanceExecution(String processDefinitionId, String businessKey, String tenantId, String initiatorVariableName) {
        ExecutionEntity processInstanceExecution = new ExecutionEntity();
        processInstanceExecution.setProcessDefinitionId(processDefinitionId);
        processInstanceExecution.setBusinessKey(businessKey);
        processInstanceExecution.setScope(true);
        if (tenantId != null) {
            processInstanceExecution.setTenantId(tenantId);
        }
        this.getExecutionEntityManager().insert(processInstanceExecution, false);
        String authenticatedUserId = Authentication.getAuthenticatedUserId();
        if (initiatorVariableName != null) {
            processInstanceExecution.setVariable(initiatorVariableName, authenticatedUserId);
        }
        processInstanceExecution.setProcessInstanceId(processInstanceExecution.getId());
        processInstanceExecution.setRootProcessInstanceId(processInstanceExecution.getId());
        if (authenticatedUserId != null) {
            this.getIdentityLinkEntityManager().addIdentityLink(processInstanceExecution, authenticatedUserId, null, "starter");
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, processInstanceExecution));
        }
        return processInstanceExecution;
    }

    @Override
    public ExecutionEntity createChildExecution(ExecutionEntity parentExecutionEntity) {
        ExecutionEntity childExecution = new ExecutionEntity();
        if (parentExecutionEntity.getTenantId() != null) {
            childExecution.setTenantId(parentExecutionEntity.getTenantId());
        }
        this.insert(childExecution, false);
        parentExecutionEntity.getExecutions().add(childExecution);
        childExecution.setParent(parentExecutionEntity);
        childExecution.setProcessDefinitionId(parentExecutionEntity.getProcessDefinitionId());
        childExecution.setProcessInstanceId(parentExecutionEntity.getProcessInstanceId() != null ? parentExecutionEntity.getProcessInstanceId() : parentExecutionEntity.getId());
        childExecution.setRootProcessInstanceId(parentExecutionEntity.getRootProcessInstanceId());
        childExecution.setScope(false);
        if (logger.isDebugEnabled()) {
            logger.debug("Child execution {} created with parent {}", (Object)childExecution, (Object)parentExecutionEntity.getId());
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_CREATED, childExecution));
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_INITIALIZED, childExecution));
        }
        return childExecution;
    }

    @Override
    public void updateExecutionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateExecutionTenantIdForDeployment", params);
    }

    @Override
    public void deleteProcessInstancesByProcessDefinition(String processDefinitionId, String deleteReason, boolean cascade) {
        List processInstanceIds = this.getDbSqlSession().selectList("selectProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
        for (String processInstanceId : processInstanceIds) {
            this.deleteProcessInstance(processInstanceId, deleteReason, cascade);
        }
        if (cascade) {
            this.getHistoricProcessInstanceEntityManager().deleteHistoricProcessInstanceByProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void deleteProcessInstance(String processInstanceId, String deleteReason, boolean cascade) {
        ExecutionEntity execution = (ExecutionEntity)this.findById(processInstanceId);
        if (execution == null) {
            throw new ActivitiObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        this.deleteProcessInstanceCascade(execution, deleteReason, cascade);
    }

    private void deleteProcessInstanceCascade(ExecutionEntity execution, String deleteReason, boolean deleteHistory) {
        for (ExecutionEntity subExecutionEntity : execution.getExecutions()) {
            if (subExecutionEntity.getSubProcessInstance() == null) continue;
            this.deleteProcessInstanceCascade(subExecutionEntity.getSubProcessInstance(), deleteReason, deleteHistory);
        }
        IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkEntityManager();
        List<IdentityLinkEntity> identityLinkEntities = identityLinkEntityManager.findIdentityLinksByProcessInstanceId(execution.getId());
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntities) {
            identityLinkEntityManager.delete(identityLinkEntity);
        }
        this.getTaskEntityManager().deleteTasksByProcessInstanceId(execution.getId(), deleteReason, deleteHistory);
        ExecutionTree executionTree = this.findExecutionTreeInCurrentProcessInstance(execution.getProcessInstanceId());
        ExecutionTreeNode executionTreeNode = null;
        if (executionTree.getRoot() != null) {
            executionTreeNode = executionTree.getTreeNode(execution.getId());
        }
        if (executionTreeNode == null) {
            return;
        }
        ExecutionTreeBfsIterator iterator = executionTreeNode.leafsFirstIterator();
        while (iterator.hasNext()) {
            ExecutionEntity childExecutionEntity = ((ExecutionTreeNode)iterator.next()).getExecutionEntity();
            this.deleteExecutionAndRelatedData(childExecutionEntity, deleteReason, false);
        }
        this.deleteExecutionAndRelatedData(execution, deleteReason, false);
        if (deleteHistory) {
            this.getHistoricProcessInstanceEntityManager().delete(execution.getId());
        }
    }

    @Override
    public void deleteExecutionAndRelatedData(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        this.deleteDataRelatedToExecution(executionEntity, deleteReason, cancel);
        this.delete(executionEntity);
    }

    @Override
    public void deleteProcessInstanceExecutionEntity(String processInstanceId, String currentFlowElementId, String deleteReason, boolean cascade, boolean cancel, boolean fireEvent) {
        ExecutionEntity processInstanceEntity = (ExecutionEntity)this.findById(processInstanceId);
        if (processInstanceEntity == null) {
            throw new ActivitiObjectNotFoundException("No process instance found for id '" + processInstanceId + "'", ProcessInstance.class);
        }
        if (processInstanceEntity.isDeleted()) {
            return;
        }
        for (ExecutionEntity subExecutionEntity : processInstanceEntity.getExecutions()) {
            if (subExecutionEntity.getSubProcessInstance() == null) continue;
            this.deleteProcessInstanceCascade(subExecutionEntity.getSubProcessInstance(), deleteReason, cascade);
        }
        for (ExecutionEntity childExecution : processInstanceEntity.getExecutions()) {
            if (!childExecution.isEventScope()) continue;
            this.deleteExecutionAndRelatedData(childExecution, null, false);
        }
        this.deleteChildExecutions(processInstanceEntity, deleteReason, cancel);
        this.deleteExecutionAndRelatedData(processInstanceEntity, deleteReason, cancel);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED, processInstanceEntity));
        }
        this.getHistoryManager().recordProcessInstanceEnd(processInstanceEntity.getId(), deleteReason, currentFlowElementId);
        processInstanceEntity.setDeleted(true);
    }

    @Override
    public void deleteChildExecutions(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        ExecutionTree executionTree = this.findExecutionTree(executionEntity.getRootProcessInstanceId());
        ExecutionTreeNode executionTreeNode = executionTree.getTreeNode(executionEntity.getId());
        if (executionTreeNode == null) {
            return;
        }
        ExecutionTreeBfsIterator iterator = executionTreeNode.leafsFirstIterator();
        while (iterator.hasNext()) {
            ExecutionEntity childExecutionEntity = ((ExecutionTreeNode)iterator.next()).getExecutionEntity();
            if (!childExecutionEntity.isActive() || childExecutionEntity.isEnded() || executionTreeNode.getExecutionEntity().getId().equals(childExecutionEntity.getId())) continue;
            this.deleteExecutionAndRelatedData(childExecutionEntity, deleteReason, cancel);
        }
    }

    @Override
    public void deleteDataRelatedToExecution(ExecutionEntity executionEntity, String deleteReason, boolean cancel) {
        executionEntity.setEnded(true);
        executionEntity.setActive(false);
        if (executionEntity.getId().equals(executionEntity.getProcessInstanceId())) {
            IdentityLinkEntityManager identityLinkEntityManager = this.getIdentityLinkEntityManager();
            List<IdentityLinkEntity> identityLinks = identityLinkEntityManager.findIdentityLinksByProcessInstanceId(executionEntity.getProcessInstanceId());
            for (IdentityLinkEntity identityLink : identityLinks) {
                identityLinkEntityManager.delete(identityLink);
            }
        }
        VariableInstanceEntityManager variableInstanceEntityManager = this.getVariableInstanceEntityManager();
        Collection<VariableInstanceEntity> executionVariables = variableInstanceEntityManager.findVariableInstancesByExecutionId(executionEntity.getId());
        for (VariableInstanceEntity variableInstanceEntity : executionVariables) {
            variableInstanceEntityManager.delete(variableInstanceEntity);
            if (variableInstanceEntity.getByteArrayRef() == null || variableInstanceEntity.getByteArrayRef().getId() == null) continue;
            this.getByteArrayEntityManager().deleteByteArrayById(variableInstanceEntity.getByteArrayRef().getId());
        }
        TaskEntityManager taskEntityManager = this.getTaskEntityManager();
        List<TaskEntity> tasksForExecution = taskEntityManager.findTasksByExecutionId(executionEntity.getId());
        for (TaskEntity taskEntity : tasksForExecution) {
            taskEntityManager.deleteTask(taskEntity, deleteReason, false, cancel);
        }
        JobEntityManager jobEntityManager = this.getJobEntityManager();
        List<JobEntity> jobsForExecution = jobEntityManager.findJobsByExecutionId(executionEntity.getId());
        for (JobEntity job : jobsForExecution) {
            this.getJobEntityManager().delete(job);
            if (!this.getEventDispatcher().isEnabled()) continue;
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.JOB_CANCELED, job));
        }
        EventSubscriptionEntityManager eventSubscriptionEntityManager = this.getEventSubscriptionEntityManager();
        List<EventSubscriptionEntity> eventSubscriptions = eventSubscriptionEntityManager.findEventSubscriptionsByExecution(executionEntity.getId());
        for (EventSubscriptionEntity eventSubscription : eventSubscriptions) {
            eventSubscriptionEntityManager.delete(eventSubscription);
        }
    }

    @Override
    public void updateProcessInstanceLockTime(String processInstanceId) {
        Date expirationTime = this.getClock().getCurrentTime();
        int lockMillis = this.getAsyncExecutor().getAsyncJobLockTimeInMillis();
        GregorianCalendar lockCal = new GregorianCalendar();
        lockCal.setTime(expirationTime);
        lockCal.add(14, lockMillis);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", processInstanceId);
        params.put("lockTime", lockCal.getTime());
        params.put("expirationTime", expirationTime);
        int result = this.getDbSqlSession().update("updateProcessInstanceLockTime", params);
        if (result == 0) {
            throw new ActivitiOptimisticLockingException("Could not lock process instance");
        }
    }

    @Override
    public void clearProcessInstanceLockTime(String processInstanceId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", processInstanceId);
        this.getDbSqlSession().update("clearProcessInstanceLockTime", params);
    }

    @Override
    public String updateProcessInstanceBusinessKey(ExecutionEntity executionEntity, String businessKey) {
        if (executionEntity.isProcessInstanceType() && businessKey != null) {
            executionEntity.setBusinessKey(businessKey);
            this.getHistoryManager().updateProcessBusinessKeyInHistory(executionEntity);
            if (this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, executionEntity));
            }
            return businessKey;
        }
        return null;
    }
}

