/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricDetail;
import org.activiti.engine.impl.HistoricDetailQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.activiti.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;

public class HistoricDetailEntityManagerImpl
extends AbstractEntityManager<HistoricDetailEntity>
implements HistoricDetailEntityManager {
    @Override
    public HistoricFormPropertyEntity insertHistoricFormPropertyEntity(ExecutionEntity execution, String propertyId, String propertyValue, String taskId) {
        HistoricFormPropertyEntity historicFormPropertyEntity = new HistoricFormPropertyEntity();
        historicFormPropertyEntity.setProcessInstanceId(execution.getProcessInstanceId());
        historicFormPropertyEntity.setExecutionId(execution.getId());
        historicFormPropertyEntity.setTaskId(taskId);
        historicFormPropertyEntity.setPropertyId(propertyId);
        historicFormPropertyEntity.setPropertyValue(propertyValue);
        historicFormPropertyEntity.setTime(this.getClock().getCurrentTime());
        HistoricActivityInstanceEntity historicActivityInstance = this.getHistoryManager().findActivityInstance(execution, true, false);
        if (historicActivityInstance != null) {
            historicFormPropertyEntity.setActivityInstanceId(historicActivityInstance.getId());
        }
        this.insert(historicFormPropertyEntity);
        return historicFormPropertyEntity;
    }

    @Override
    public HistoricDetailVariableInstanceUpdateEntity copyAndInsertHistoricDetailVariableInstanceUpdateEntity(VariableInstanceEntity variableInstance) {
        HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = new HistoricDetailVariableInstanceUpdateEntity();
        historicVariableUpdate.processInstanceId = variableInstance.getProcessInstanceId();
        historicVariableUpdate.executionId = variableInstance.getExecutionId();
        historicVariableUpdate.taskId = variableInstance.getTaskId();
        historicVariableUpdate.time = this.getClock().getCurrentTime();
        historicVariableUpdate.revision = variableInstance.getRevision();
        historicVariableUpdate.name = variableInstance.getName();
        historicVariableUpdate.variableType = variableInstance.getType();
        historicVariableUpdate.textValue = variableInstance.getTextValue();
        historicVariableUpdate.textValue2 = variableInstance.getTextValue2();
        historicVariableUpdate.doubleValue = variableInstance.getDoubleValue();
        historicVariableUpdate.longValue = variableInstance.getLongValue();
        if (variableInstance.getBytes() != null) {
            String byteArrayName = "hist.detail.var-" + variableInstance.getName();
            historicVariableUpdate.byteArrayRef.setValue(byteArrayName, variableInstance.getBytes());
        }
        this.insert(historicVariableUpdate);
        return historicVariableUpdate;
    }

    @Override
    public void delete(HistoricDetailEntity entity, boolean fireDeleteEvent) {
        super.delete(entity, fireDeleteEvent);
        if (entity instanceof HistoricDetailVariableInstanceUpdateEntity) {
            ((HistoricDetailVariableInstanceUpdateEntity)entity).getByteArrayRef().delete();
        }
    }

    @Override
    public void deleteHistoricDetailsByProcessInstanceId(String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            List historicDetails = this.getDbSqlSession().createHistoricDetailQuery().processInstanceId(historicProcessInstanceId).list();
            for (HistoricDetailEntity historicDetail : historicDetails) {
                this.delete(historicDetail);
            }
        }
    }

    @Override
    public long findHistoricDetailCountByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricDetailCountByQueryCriteria", historicVariableUpdateQuery);
    }

    @Override
    public List<HistoricDetail> findHistoricDetailsByQueryCriteria(HistoricDetailQueryImpl historicVariableUpdateQuery, Page page) {
        return this.getDbSqlSession().selectList("selectHistoricDetailsByQueryCriteria", historicVariableUpdateQuery, page);
    }

    @Override
    public void deleteHistoricDetailsByTaskId(String taskId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            HistoricDetailQueryImpl detailsQuery = new HistoricDetailQueryImpl().taskId(taskId);
            List details = detailsQuery.list();
            for (HistoricDetail detail : details) {
                this.delete((HistoricDetailEntity)detail);
            }
        }
    }

    @Override
    public List<HistoricDetail> findHistoricDetailsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricDetailByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findHistoricDetailCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricDetailCountByNativeQuery", parameterMap);
    }
}

