/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.activiti.engine.impl.util.Activiti5Util;

public class HistoricTaskInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricTaskInstanceEntity>
implements HistoricTaskInstanceEntityManager {
    @Override
    public Class<HistoricTaskInstanceEntity> getManagedEntity() {
        return HistoricTaskInstanceEntity.class;
    }

    @Override
    public void deleteHistoricTaskInstancesByProcessInstanceId(String processInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            List taskInstanceIds = this.getDbSqlSession().selectList("selectHistoricTaskInstanceIdsByProcessInstanceId", processInstanceId);
            for (String taskInstanceId : taskInstanceIds) {
                this.delete(taskInstanceId);
            }
        }
    }

    @Override
    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByQueryCriteria", historicTaskInstanceQuery);
        }
        return 0L;
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            return this.getDbSqlSession().selectList("selectHistoricTaskInstancesByQueryCriteria", historicTaskInstanceQuery);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesAndVariablesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (this.getHistoryManager().isHistoryEnabled()) {
            if (historicTaskInstanceQuery.getFirstResult() < 0 || historicTaskInstanceQuery.getMaxResults() <= 0) {
                return Collections.EMPTY_LIST;
            }
            int firstResult = historicTaskInstanceQuery.getFirstResult();
            int maxResults = historicTaskInstanceQuery.getMaxResults();
            historicTaskInstanceQuery.setMaxResults(20000);
            historicTaskInstanceQuery.setFirstResult(0);
            List instanceList = this.getDbSqlSession().selectListWithRawParameterWithoutFilter("selectHistoricTaskInstancesWithVariablesByQueryCriteria", historicTaskInstanceQuery, historicTaskInstanceQuery.getFirstResult(), historicTaskInstanceQuery.getMaxResults());
            if (instanceList != null && !instanceList.isEmpty()) {
                if (firstResult > 0) {
                    if (firstResult <= instanceList.size()) {
                        int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                        return instanceList.subList(firstResult, toIndex);
                    }
                    return Collections.EMPTY_LIST;
                }
                int toIndex = Math.min(maxResults, instanceList.size());
                return instanceList.subList(0, toIndex);
            }
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void delete(String id) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.getHistoryManager().isHistoryEnabled() && (historicTaskInstance = (HistoricTaskInstanceEntity)this.findById(id)) != null) {
            if (historicTaskInstance.getProcessDefinitionId() != null && Activiti5Util.isActiviti5ProcessDefinitionId(this.getCommandContext(), historicTaskInstance.getProcessDefinitionId())) {
                Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                activiti5CompatibilityHandler.deleteHistoricTask(id);
                return;
            }
            this.getHistoricDetailEntityManager().deleteHistoricDetailsByTaskId(id);
            this.getHistoricVariableInstanceEntityManager().deleteHistoricVariableInstancesByTaskId(id);
            this.getCommentEntityManager().deleteCommentsByTaskId(id);
            this.getAttachmentEntityManager().deleteAttachmentsByTaskId(id);
            this.getHistoricIdentityLinkEntityManager().deleteHistoricIdentityLinksByTaskId(id);
            this.getDbSqlSession().delete(historicTaskInstance);
        }
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricTaskInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findHistoricTaskInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByNativeQuery", parameterMap);
    }
}

