/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.activiti.engine.history.HistoricVariableInstance;
import org.activiti.engine.impl.HistoricVariableInstanceQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.persistence.CachedEntityMatcher;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntityManager;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;

public class HistoricVariableInstanceEntityManagerImpl
extends AbstractEntityManager<HistoricVariableInstanceEntity>
implements HistoricVariableInstanceEntityManager {
    @Override
    public Class<HistoricVariableInstanceEntity> getManagedEntity() {
        return HistoricVariableInstanceEntity.class;
    }

    @Override
    public HistoricVariableInstanceEntity copyAndInsert(VariableInstanceEntity variableInstance) {
        HistoricVariableInstanceEntity historicVariableInstance = new HistoricVariableInstanceEntity();
        historicVariableInstance.setId(variableInstance.getId());
        historicVariableInstance.setProcessInstanceId(variableInstance.getProcessInstanceId());
        historicVariableInstance.setExecutionId(variableInstance.getExecutionId());
        historicVariableInstance.setTaskId(variableInstance.getTaskId());
        historicVariableInstance.setRevision(variableInstance.getRevision());
        historicVariableInstance.setName(variableInstance.getName());
        historicVariableInstance.setVariableType(variableInstance.getType());
        this.copyVariableValue(historicVariableInstance, variableInstance);
        Date time = this.getClock().getCurrentTime();
        historicVariableInstance.setCreateTime(time);
        historicVariableInstance.setLastUpdatedTime(time);
        this.insert(historicVariableInstance);
        return historicVariableInstance;
    }

    @Override
    public void copyVariableValue(HistoricVariableInstanceEntity historicVariableInstance, VariableInstanceEntity variableInstance) {
        historicVariableInstance.textValue = variableInstance.getTextValue();
        historicVariableInstance.textValue2 = variableInstance.getTextValue2();
        historicVariableInstance.doubleValue = variableInstance.getDoubleValue();
        historicVariableInstance.longValue = variableInstance.getLongValue();
        historicVariableInstance.variableType = variableInstance.getType();
        if (variableInstance.getByteArrayRef() != null) {
            historicVariableInstance.setBytes(variableInstance.getBytes());
        }
        historicVariableInstance.lastUpdatedTime = this.getClock().getCurrentTime();
    }

    @Override
    public void delete(HistoricVariableInstanceEntity entity, boolean fireDeleteEvent) {
        super.delete(entity, fireDeleteEvent);
        if (entity.getByteArrayRef() != null) {
            entity.getByteArrayRef().delete();
        }
    }

    @Override
    public void deleteHistoricVariableInstanceByProcessInstanceId(final String historicProcessInstanceId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List<HistoricVariableInstanceEntity> historicProcessVariables = this.getList("selectHistoricVariableInstanceByProcessInstanceId", historicProcessInstanceId, new CachedEntityMatcher<HistoricVariableInstanceEntity>(){

                @Override
                public boolean isRetained(HistoricVariableInstanceEntity historicVariableInstanceEntity) {
                    return historicVariableInstanceEntity.getProcessInstanceId() != null && historicVariableInstanceEntity.getProcessInstanceId().equals(historicProcessInstanceId);
                }
            }, true);
            for (HistoricVariableInstanceEntity historicProcessVariable : historicProcessVariables) {
                this.delete(historicProcessVariable);
            }
        }
    }

    @Override
    public long findHistoricVariableInstanceCountByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceCountByQueryCriteria", historicProcessVariableQuery);
    }

    @Override
    public List<HistoricVariableInstance> findHistoricVariableInstancesByQueryCriteria(HistoricVariableInstanceQueryImpl historicProcessVariableQuery, Page page) {
        return this.getDbSqlSession().selectList("selectHistoricVariableInstanceByQueryCriteria", historicProcessVariableQuery, page);
    }

    @Override
    public HistoricVariableInstanceEntity findHistoricVariableInstanceByVariableInstanceId(String variableInstanceId) {
        return (HistoricVariableInstanceEntity)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceByVariableInstanceId", variableInstanceId);
    }

    @Override
    public void deleteHistoricVariableInstancesByTaskId(String taskId) {
        if (this.getHistoryManager().isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            List historicProcessVariables = new HistoricVariableInstanceQueryImpl().taskId(taskId).list();
            for (HistoricVariableInstance historicProcessVariable : historicProcessVariables) {
                this.delete((HistoricVariableInstanceEntity)historicProcessVariable);
            }
        }
    }

    @Override
    public List<HistoricVariableInstance> findHistoricVariableInstancesByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricVariableInstanceByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findHistoricVariableInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricVariableInstanceCountByNativeQuery", parameterMap);
    }
}

