/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntity;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntityManager;

public class IdentityInfoEntityManagerImpl
extends AbstractEntityManager<IdentityInfoEntity>
implements IdentityInfoEntityManager {
    @Override
    public Class<IdentityInfoEntity> getManagedEntity() {
        return IdentityInfoEntity.class;
    }

    @Override
    public void deleteUserInfoByUserIdAndKey(String userId, String key) {
        IdentityInfoEntity identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key);
        if (identityInfoEntity != null) {
            this.delete(identityInfoEntity);
        }
    }

    protected List<IdentityInfoEntity> findIdentityInfoDetails(String identityInfoId) {
        return this.getDbSqlSession().getSqlSession().selectList("selectIdentityInfoDetails", (Object)identityInfoId);
    }

    @Override
    public void updateUserInfo(String userId, String userPassword, String type, String key, String value, String accountPassword, Map<String, String> accountDetails) {
        IdentityInfoEntity identityInfoEntity;
        byte[] storedPassword = null;
        if (accountPassword != null) {
            storedPassword = this.encryptPassword(accountPassword, userPassword);
        }
        if ((identityInfoEntity = this.findUserInfoByUserIdAndKey(userId, key)) != null) {
            identityInfoEntity.setValue(value);
            identityInfoEntity.setPasswordBytes(storedPassword);
            if (accountDetails == null) {
                accountDetails = new HashMap<String, String>();
            }
            HashSet<String> newKeys = new HashSet<String>(accountDetails.keySet());
            List<IdentityInfoEntity> identityInfoDetails = this.findIdentityInfoDetails(identityInfoEntity.getId());
            for (IdentityInfoEntity identityInfoDetail : identityInfoDetails) {
                String detailKey = identityInfoDetail.getKey();
                newKeys.remove(detailKey);
                String newDetailValue = accountDetails.get(detailKey);
                if (newDetailValue == null) {
                    this.delete(identityInfoDetail);
                    continue;
                }
                identityInfoDetail.setValue(newDetailValue);
            }
            this.insertAccountDetails(identityInfoEntity, accountDetails, newKeys);
        } else {
            identityInfoEntity = new IdentityInfoEntity();
            identityInfoEntity.setUserId(userId);
            identityInfoEntity.setType(type);
            identityInfoEntity.setKey(key);
            identityInfoEntity.setValue(value);
            identityInfoEntity.setPasswordBytes(storedPassword);
            this.getDbSqlSession().insert(identityInfoEntity);
            if (accountDetails != null) {
                this.insertAccountDetails(identityInfoEntity, accountDetails, accountDetails.keySet());
            }
        }
    }

    private void insertAccountDetails(IdentityInfoEntity identityInfoEntity, Map<String, String> accountDetails, Set<String> keys) {
        for (String newKey : keys) {
            IdentityInfoEntity identityInfoDetail = new IdentityInfoEntity();
            identityInfoDetail.setParentId(identityInfoEntity.getId());
            identityInfoDetail.setKey(newKey);
            identityInfoDetail.setValue(accountDetails.get(newKey));
            this.getDbSqlSession().insert(identityInfoDetail);
        }
    }

    protected byte[] encryptPassword(String accountPassword, String userPassword) {
        return accountPassword.getBytes();
    }

    protected String decryptPassword(byte[] storedPassword, String userPassword) {
        return new String(storedPassword);
    }

    @Override
    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId, String key) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("key", key);
        return (IdentityInfoEntity)this.getDbSqlSession().selectOne("selectIdentityInfoByUserIdAndKey", parameters);
    }

    @Override
    public List<String> findUserInfoKeysByUserIdAndType(String userId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("type", type);
        return this.getDbSqlSession().getSqlSession().selectList("selectIdentityInfoKeysByUserIdAndType", parameters);
    }
}

