/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntityManager;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

public class IdentityLinkEntityManagerImpl
extends AbstractEntityManager<IdentityLinkEntity>
implements IdentityLinkEntityManager {
    @Override
    public Class<IdentityLinkEntity> getManagedEntity() {
        return IdentityLinkEntity.class;
    }

    @Override
    public void insert(IdentityLinkEntity entity, boolean fireCreateEvent) {
        super.insert(entity, fireCreateEvent);
        this.getHistoryManager().recordIdentityLinkCreated(entity);
    }

    @Override
    public void deleteIdentityLink(IdentityLinkEntity identityLink, boolean cascadeHistory) {
        this.getDbSqlSession().delete(identityLink);
        if (cascadeHistory) {
            this.getHistoryManager().deleteHistoricIdentityLink(identityLink.getId());
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, identityLink));
        }
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByTask", taskId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByProcessInstance", processInstanceId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(String processDefinitionId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByProcessDefinition", processDefinitionId);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByTaskUserGroupAndType(String taskId, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectIdentityLinkByTaskUserGroupAndType", parameters);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessInstanceUserGroupAndType(String processInstanceId, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectIdentityLinkByProcessInstanceUserGroupAndType", parameters);
    }

    @Override
    public List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUserAndGroup(String processDefinitionId, String userId, String groupId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        return this.getDbSqlSession().selectList("selectIdentityLinkByProcessDefinitionUserAndGroup", parameters);
    }

    @Override
    public IdentityLinkEntity addIdentityLink(ExecutionEntity executionEntity, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        executionEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessInstance(executionEntity.getProcessInstance() != null ? executionEntity.getProcessInstance() : executionEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addIdentityLink(TaskEntity taskEntity, String userId, String groupId, String type) {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        taskEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setTask(taskEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType(type);
        this.insert(identityLinkEntity);
        if (userId != null && taskEntity.getProcessInstanceId() != null) {
            this.involveUser(taskEntity.getProcessInstance(), userId, "participant");
        }
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity addIdentityLink(ProcessDefinitionEntity processDefinitionEntity, String userId, String groupId) {
        IdentityLinkEntity identityLinkEntity = new IdentityLinkEntity();
        processDefinitionEntity.getIdentityLinks().add(identityLinkEntity);
        identityLinkEntity.setProcessDef(processDefinitionEntity);
        identityLinkEntity.setUserId(userId);
        identityLinkEntity.setGroupId(groupId);
        identityLinkEntity.setType("candidate");
        this.insert(identityLinkEntity);
        return identityLinkEntity;
    }

    @Override
    public IdentityLinkEntity involveUser(ExecutionEntity executionEntity, String userId, String type) {
        for (IdentityLinkEntity identityLink : executionEntity.getIdentityLinks()) {
            if (!identityLink.isUser() || !identityLink.getUserId().equals(userId)) continue;
            return identityLink;
        }
        return this.addIdentityLink(executionEntity, userId, null, type);
    }

    @Override
    public void addCandidateUser(TaskEntity taskEntity, String userId) {
        this.addIdentityLink(taskEntity, userId, null, "candidate");
    }

    @Override
    public void addCandidateUsers(TaskEntity taskEntity, Collection<String> candidateUsers) {
        for (String candidateUser : candidateUsers) {
            this.addCandidateUser(taskEntity, candidateUser);
        }
    }

    @Override
    public void addCandidateGroup(TaskEntity taskEntity, String groupId) {
        this.addIdentityLink(taskEntity, null, groupId, "candidate");
    }

    @Override
    public void addCandidateGroups(TaskEntity taskEntity, Collection<String> candidateGroups) {
        for (String candidateGroup : candidateGroups) {
            this.addCandidateGroup(taskEntity, candidateGroup);
        }
    }

    @Override
    public void addGroupIdentityLink(TaskEntity taskEntity, String groupId, String identityLinkType) {
        this.addIdentityLink(taskEntity, null, groupId, identityLinkType);
    }

    @Override
    public void addUserIdentityLink(TaskEntity taskEntity, String userId, String identityLinkType) {
        this.addIdentityLink(taskEntity, userId, null, identityLinkType);
    }

    @Override
    public void deleteIdentityLink(ExecutionEntity executionEntity, String userId, String groupId, String type) {
        String id = executionEntity.getProcessInstanceId() != null ? executionEntity.getProcessInstanceId() : executionEntity.getId();
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByProcessInstanceUserGroupAndType(id, userId, groupId, type);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, true);
        }
        executionEntity.getIdentityLinks().removeAll(identityLinks);
    }

    @Override
    public void deleteIdentityLink(TaskEntity taskEntity, String userId, String groupId, String type) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinkByTaskUserGroupAndType(taskEntity.getId(), userId, groupId, type);
        ArrayList<String> identityLinkIds = new ArrayList<String>();
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, true);
            identityLinkIds.add(identityLink.getId());
        }
        ArrayList<IdentityLinkEntity> removedIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
        for (IdentityLinkEntity identityLinkEntity : taskEntity.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType()) || identityLinkIds.contains(identityLinkEntity.getId()) || (userId == null || !userId.equals(identityLinkEntity.getUserId())) && (groupId == null || !groupId.equals(identityLinkEntity.getGroupId()))) continue;
            this.deleteIdentityLink(identityLinkEntity, true);
            removedIdentityLinkEntities.add(identityLinkEntity);
        }
        taskEntity.getIdentityLinks().removeAll(removedIdentityLinkEntities);
    }

    @Override
    public void deleteIdentityLink(ProcessDefinitionEntity processDefinitionEntity, String userId, String groupId) {
        List<IdentityLinkEntity> identityLinks = this.getIdentityLinkEntityManager().findIdentityLinkByProcessDefinitionUserAndGroup(processDefinitionEntity.getId(), userId, groupId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, false);
        }
    }

    @Override
    public void deleteIdentityLinksByTaskId(String taskId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinksByTaskId(taskId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink, false);
        }
    }

    @Override
    public void deleteIdentityLinksByProcDef(String processDefId) {
        this.getDbSqlSession().delete("deleteIdentityLinkByProcDef", processDefId);
    }
}

