/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.calendar.CycleBusinessCalendar;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.el.NoExecutionVariableScope;
import org.activiti.engine.impl.jobexecutor.AsyncJobAddedNotification;
import org.activiti.engine.impl.jobexecutor.JobAddedNotification;
import org.activiti.engine.impl.jobexecutor.JobHandler;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.CachedEntityMatcher;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ByteArrayRef;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.JobEntityManager;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEntityManagerImpl
extends AbstractEntityManager<JobEntity>
implements JobEntityManager {
    private static final Logger logger = LoggerFactory.getLogger(JobEntityManagerImpl.class);
    protected static final List<Class<? extends JobEntity>> ENTITY_SUBCLASSES = Arrays.asList(TimerEntity.class, MessageEntity.class);

    @Override
    public Class<JobEntity> getManagedEntity() {
        return JobEntity.class;
    }

    @Override
    public List<Class<? extends JobEntity>> getManagedEntitySubClasses() {
        return ENTITY_SUBCLASSES;
    }

    @Override
    public void insert(JobEntity jobEntity, boolean fireCreateEvent) {
        if (jobEntity.getExecutionId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
            execution.getJobs().add(jobEntity);
            if (execution.getTenantId() != null) {
                jobEntity.setTenantId(execution.getTenantId());
            }
        }
        super.insert(jobEntity, fireCreateEvent);
    }

    @Override
    public void send(MessageEntity message) {
        ProcessEngineConfigurationImpl processEngineConfiguration = this.getProcessEngineConfiguration();
        if (processEngineConfiguration.isAsyncExecutorEnabled()) {
            Date dueDate = new Date(this.getClock().getCurrentTime().getTime() + (long)processEngineConfiguration.getAsyncExecutor().getAsyncJobLockTimeInMillis());
            message.setDuedate(dueDate);
            message.setLockExpirationTime(null);
        } else if (!processEngineConfiguration.isJobExecutorActivate()) {
            message.setDuedate(processEngineConfiguration.getClock().getCurrentTime());
            message.setLockExpirationTime(null);
        }
        this.insert(message);
        if (processEngineConfiguration.isAsyncExecutorEnabled()) {
            this.hintAsyncExecutor(message);
        } else {
            this.hintJobExecutor(message);
        }
    }

    @Override
    public void schedule(TimerEntity timer) {
        Date duedate = timer.getDuedate();
        if (duedate == null) {
            throw new ActivitiIllegalArgumentException("duedate is null");
        }
        this.insert(timer);
        if (!this.getProcessEngineConfiguration().isAsyncExecutorEnabled() && timer.getDuedate().getTime() <= this.getClock().getCurrentTime().getTime()) {
            this.hintJobExecutor(timer);
        }
    }

    @Override
    public void retryAsyncJob(JobEntity job) {
        try {
            Thread.sleep(this.getAsyncExecutor().getRetryWaitTimeInMillis());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getAsyncExecutor().executeAsyncJob(job);
    }

    protected void hintAsyncExecutor(JobEntity job) {
        AsyncJobAddedNotification transactionListener = new AsyncJobAddedNotification(job, this.getAsyncExecutor());
        this.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionListener);
    }

    protected void hintJobExecutor(JobEntity job) {
        JobAddedNotification transactionListener = new JobAddedNotification(this.getJobExecutor());
        this.getCommandContext().getTransactionContext().addTransactionListener(TransactionState.COMMITTED, transactionListener);
    }

    @Override
    public List<JobEntity> findNextJobsToExecute(Page page) {
        Date now = this.getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectNextJobsToExecute", now, page);
    }

    @Override
    public List<JobEntity> findNextTimerJobsToExecute(Page page) {
        Date now = this.getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectNextTimerJobsToExecute", now, page);
    }

    @Override
    public List<JobEntity> findAsyncJobsDueToExecute(Page page) {
        Date now = this.getClock().getCurrentTime();
        return this.getDbSqlSession().selectList("selectAsyncJobsDueToExecute", now, page);
    }

    @Override
    public List<JobEntity> findJobsByLockOwner(String lockOwner, int start, int maxNrOfJobs) {
        return this.getDbSqlSession().selectList("selectJobsByLockOwner", lockOwner, start, maxNrOfJobs);
    }

    @Override
    public List<JobEntity> findJobsByExecutionId(final String executionId) {
        return this.getList("selectJobsByExecutionId", executionId, new CachedEntityMatcher<JobEntity>(){

            @Override
            public boolean isRetained(JobEntity jobEntity) {
                return jobEntity.getExecutionId() != null && jobEntity.getExecutionId().equals(executionId);
            }
        }, true);
    }

    @Override
    public List<JobEntity> findExclusiveJobsToExecute(String processInstanceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", processInstanceId);
        params.put("now", this.getClock().getCurrentTime());
        return this.getDbSqlSession().selectList("selectExclusiveJobsToExecute", params);
    }

    @Override
    public List<TimerEntity> findUnlockedTimersByDuedate(Date duedate, Page page) {
        String query = "selectUnlockedTimersByDuedate";
        return this.getDbSqlSession().selectList("selectUnlockedTimersByDuedate", duedate, page);
    }

    @Override
    public List<TimerEntity> findTimersByExecutionId(String executionId) {
        return this.getDbSqlSession().selectList("selectTimersByExecutionId", executionId);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(JobQueryImpl jobQuery, Page page) {
        String query = "selectJobByQueryCriteria";
        return this.getDbSqlSession().selectList("selectJobByQueryCriteria", jobQuery, page);
    }

    @Override
    public List<Job> findJobsByTypeAndProcessDefinitionIds(String jobHandlerType, List<String> processDefinitionIds) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("handlerType", jobHandlerType);
        if (processDefinitionIds != null && processDefinitionIds.size() > 0) {
            params.put("processDefinitionIds", processDefinitionIds);
        }
        return this.getDbSqlSession().selectList("selectJobsByTypeAndProcessDefinitionIds", params);
    }

    @Override
    public List<Job> findJobsByTypeAndProcessDefinitionKeyNoTenantId(String jobHandlerType, String processDefinitionKey) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionKey", processDefinitionKey);
        return this.getDbSqlSession().selectList("selectJobByTypeAndProcessDefinitionKeyNoTenantId", params);
    }

    @Override
    public List<Job> findJobsByTypeAndProcessDefinitionKeyAndTenantId(String jobHandlerType, String processDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionKey", processDefinitionKey);
        params.put("tenantId", tenantId);
        return this.getDbSqlSession().selectList("selectJobByTypeAndProcessDefinitionKeyAndTenantId", params);
    }

    @Override
    public List<Job> findJobsByTypeAndProcessDefinitionId(String jobHandlerType, String processDefinitionId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("handlerType", jobHandlerType);
        params.put("processDefinitionId", processDefinitionId);
        return this.getDbSqlSession().selectList("selectJobByTypeAndProcessDefinitionId", params);
    }

    @Override
    public long findJobCountByQueryCriteria(JobQueryImpl jobQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectJobCountByQueryCriteria", jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateJobTenantIdForDeployment", params);
    }

    @Override
    public void delete(JobEntity jobEntity) {
        super.delete(jobEntity);
        ByteArrayRef exceptionByteArrayRef = jobEntity.getExceptionByteArrayRef();
        exceptionByteArrayRef.delete();
        if (jobEntity.getExecutionId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
            execution.getJobs().remove(this);
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, this));
        }
    }

    @Override
    public void execute(JobEntity jobEntity) {
        if (jobEntity instanceof MessageEntity) {
            this.executeMessageJob(jobEntity);
        } else if (jobEntity instanceof TimerEntity) {
            this.executeTimerJob((TimerEntity)jobEntity);
        }
    }

    protected void executeJobHandler(JobEntity jobEntity) {
        ExecutionEntity execution = null;
        if (jobEntity.getExecutionId() != null) {
            execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
        }
        Map<String, JobHandler> jobHandlers = this.getProcessEngineConfiguration().getJobHandlers();
        JobHandler jobHandler = jobHandlers.get(jobEntity.getJobHandlerType());
        jobHandler.execute(jobEntity, jobEntity.getJobHandlerConfiguration(), execution, this.getCommandContext());
    }

    protected void executeMessageJob(JobEntity jobEntity) {
        this.executeJobHandler(jobEntity);
        this.delete(jobEntity);
    }

    protected void executeTimerJob(TimerEntity timerEntity) {
        int repeatValue;
        this.restoreExtraData(timerEntity);
        if (timerEntity.getDuedate() != null && !this.isValidTime(timerEntity, timerEntity.getDuedate())) {
            if (logger.isDebugEnabled()) {
                logger.debug("Timer {} fired. but the dueDate is after the endDate.  Deleting timer.", (Object)timerEntity.getId());
            }
            this.delete(timerEntity);
            return;
        }
        this.executeJobHandler(timerEntity);
        if (logger.isDebugEnabled()) {
            logger.debug("Timer {} fired. Deleting timer.", (Object)timerEntity.getId());
        }
        this.delete(timerEntity);
        if (timerEntity.getRepeat() != null && (repeatValue = this.calculateRepeatValue(timerEntity)) != 0) {
            Date newTimer;
            if (repeatValue > 0) {
                this.setNewRepeat(timerEntity, repeatValue);
            }
            if ((newTimer = this.calculateNextTimer(timerEntity)) != null && this.isValidTime(timerEntity, newTimer)) {
                TimerEntity te = new TimerEntity(timerEntity);
                te.setDuedate(newTimer);
                this.getJobEntityManager().schedule(te);
            }
        }
    }

    protected void restoreExtraData(TimerEntity timerEntity) {
        Process process;
        String activityId = timerEntity.getJobHandlerConfiguration();
        if (timerEntity.getJobHandlerType().equalsIgnoreCase("timer-start-event")) {
            activityId = TimerEventHandler.getActivityIdFromConfiguration(timerEntity.getJobHandlerConfiguration());
            String endDateExpressionString = TimerEventHandler.getEndDateFromConfiguration(timerEntity.getJobHandlerConfiguration());
            if (endDateExpressionString != null) {
                Expression endDateExpression = this.getProcessEngineConfiguration().getExpressionManager().createExpression(endDateExpressionString);
                String endDateString = null;
                BusinessCalendar businessCalendar = this.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
                VariableScope executionEntity = null;
                if (timerEntity.getExecutionId() != null) {
                    executionEntity = (VariableScope)this.getExecutionEntityManager().findById(timerEntity.getExecutionId());
                }
                if (executionEntity == null) {
                    executionEntity = NoExecutionVariableScope.getSharedInstance();
                }
                if (endDateExpression != null) {
                    Object endDateValue = endDateExpression.getValue(executionEntity);
                    if (endDateValue instanceof String) {
                        endDateString = (String)endDateValue;
                    } else if (endDateValue instanceof Date) {
                        timerEntity.setEndDate((Date)endDateValue);
                    } else {
                        throw new ActivitiException("Timer '" + ((ExecutionEntity)executionEntity).getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
                    }
                    if (timerEntity.getEndDate() == null) {
                        timerEntity.setEndDate(businessCalendar.resolveEndDate(endDateString));
                    }
                }
            }
        }
        int maxIterations = 1;
        if (timerEntity.getProcessDefinitionId() != null && (maxIterations = this.getMaxIterations(process = ProcessDefinitionUtil.getProcess(timerEntity.getProcessDefinitionId()), activityId)) <= 1) {
            maxIterations = this.getMaxIterations(process, activityId);
        }
        timerEntity.setMaxIterations(maxIterations);
    }

    protected int getMaxIterations(Process process, String activityId) {
        Event event;
        List eventDefinitions;
        FlowElement flowElement = process.getFlowElement(activityId, true);
        if (flowElement != null && flowElement instanceof Event && (eventDefinitions = (event = (Event)flowElement).getEventDefinitions()) != null) {
            for (EventDefinition eventDefinition : eventDefinitions) {
                TimerEventDefinition timerEventDefinition;
                if (!(eventDefinition instanceof TimerEventDefinition) || (timerEventDefinition = (TimerEventDefinition)eventDefinition).getTimeCycle() == null) continue;
                return this.calculateMaxIterationsValue(timerEventDefinition.getTimeCycle());
            }
        }
        return -1;
    }

    protected int calculateMaxIterationsValue(String originalExpression) {
        int times = Integer.MAX_VALUE;
        List<String> expression = Arrays.asList(originalExpression.split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R")) {
            times = Integer.MAX_VALUE;
            if (expression.get(0).length() > 1) {
                times = Integer.parseInt(expression.get(0).substring(1));
            }
        }
        return times;
    }

    protected int calculateRepeatValue(TimerEntity timerEntity) {
        int times = -1;
        List<String> expression = Arrays.asList(timerEntity.getRepeat().split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R") && expression.get(0).length() > 1 && (times = Integer.parseInt(expression.get(0).substring(1))) > 0) {
            --times;
        }
        return times;
    }

    protected void setNewRepeat(TimerEntity timerEntity, int newRepeatValue) {
        List<String> expression = Arrays.asList(timerEntity.getRepeat().split("/"));
        expression = expression.subList(1, expression.size());
        StringBuilder repeatBuilder = new StringBuilder("R");
        repeatBuilder.append(newRepeatValue);
        for (String value : expression) {
            repeatBuilder.append("/");
            repeatBuilder.append(value);
        }
        timerEntity.setRepeat(repeatBuilder.toString());
    }

    protected boolean isValidTime(TimerEntity timerEntity, Date newTimerDate) {
        BusinessCalendar businessCalendar = this.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return businessCalendar.validateDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations(), timerEntity.getEndDate(), newTimerDate);
    }

    protected Date calculateNextTimer(TimerEntity timerEntity) {
        BusinessCalendar businessCalendar = this.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(CycleBusinessCalendar.NAME);
        return businessCalendar.resolveDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations());
    }
}

