/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.MembershipEntity;
import org.activiti.engine.impl.persistence.entity.MembershipEntityManager;

public class MembershipEntityManagerImpl
extends AbstractEntityManager<MembershipEntity>
implements MembershipEntityManager {
    @Override
    public Class<MembershipEntity> getManagedEntity() {
        return MembershipEntity.class;
    }

    @Override
    public void createMembership(String userId, String groupId) {
        MembershipEntity membershipEntity = new MembershipEntity();
        membershipEntity.setUserId(userId);
        membershipEntity.setGroupId(groupId);
        this.getDbSqlSession().insert(membershipEntity);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createMembershipEvent(ActivitiEventType.MEMBERSHIP_CREATED, groupId, userId));
        }
    }

    @Override
    public void deleteMembership(String userId, String groupId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        this.getDbSqlSession().delete("deleteMembership", parameters);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createMembershipEvent(ActivitiEventType.MEMBERSHIP_DELETED, groupId, userId));
        }
    }
}

