/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.ModelQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ByteArrayRef;
import org.activiti.engine.impl.persistence.entity.ModelEntity;
import org.activiti.engine.impl.persistence.entity.ModelEntityManager;
import org.activiti.engine.repository.Model;

public class ModelEntityManagerImpl
extends AbstractEntityManager<ModelEntity>
implements ModelEntityManager {
    @Override
    public Class<ModelEntity> getManagedEntity() {
        return ModelEntity.class;
    }

    @Override
    public Model createNewModel() {
        return new ModelEntity();
    }

    @Override
    public void insert(ModelEntity model) {
        model.setCreateTime(this.getClock().getCurrentTime());
        model.setLastUpdateTime(this.getClock().getCurrentTime());
        super.insert(model);
    }

    @Override
    public void updateModel(ModelEntity updatedModel) {
        updatedModel.setLastUpdateTime(this.getClock().getCurrentTime());
        this.getDbSqlSession().update(updatedModel);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, updatedModel));
        }
    }

    @Override
    public void delete(String modelId) {
        ModelEntity modelEntity = this.getDbSqlSession().selectById(ModelEntity.class, modelId);
        super.delete(modelEntity);
        this.deleteEditorSource(modelEntity);
        this.deleteEditorSourceExtra(modelEntity);
    }

    @Override
    public void insertEditorSourceForModel(String modelId, byte[] modelSource) {
        ModelEntity model = (ModelEntity)this.findById(modelId);
        if (model != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
            ref.setValue("source", modelSource);
            if (model.getEditorSourceValueId() == null) {
                model.setEditorSourceValueId(ref.getId());
                this.updateModel(model);
            }
        }
    }

    @Override
    public void deleteEditorSource(ModelEntity model) {
        if (model.getEditorSourceValueId() != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
            ref.delete();
        }
    }

    @Override
    public void deleteEditorSourceExtra(ModelEntity model) {
        if (model.getEditorSourceExtraValueId() != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
            ref.delete();
        }
    }

    @Override
    public void insertEditorSourceExtraForModel(String modelId, byte[] modelSource) {
        ModelEntity model = (ModelEntity)this.findById(modelId);
        if (model != null) {
            ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
            ref.setValue("source-extra", modelSource);
            if (model.getEditorSourceExtraValueId() == null) {
                model.setEditorSourceExtraValueId(ref.getId());
                this.updateModel(model);
            }
        }
    }

    @Override
    public List<Model> findModelsByQueryCriteria(ModelQueryImpl query, Page page) {
        return this.getDbSqlSession().selectList("selectModelsByQueryCriteria", query, page);
    }

    @Override
    public long findModelCountByQueryCriteria(ModelQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectModelCountByQueryCriteria", query);
    }

    @Override
    public byte[] findEditorSourceByModelId(String modelId) {
        ModelEntity model = (ModelEntity)this.findById(modelId);
        if (model == null || model.getEditorSourceValueId() == null) {
            return null;
        }
        ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceValueId());
        return ref.getBytes();
    }

    @Override
    public byte[] findEditorSourceExtraByModelId(String modelId) {
        ModelEntity model = (ModelEntity)this.findById(modelId);
        if (model == null || model.getEditorSourceExtraValueId() == null) {
            return null;
        }
        ByteArrayRef ref = new ByteArrayRef(model.getEditorSourceExtraValueId());
        return ref.getBytes();
    }

    @Override
    public List<Model> findModelsByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectModelByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findModelCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectModelCountByNativeQuery", parameterMap);
    }
}

