/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.persistence.CachedEntityMatcher;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntityManager;
import org.activiti.engine.impl.util.Activiti5Util;
import org.activiti.engine.task.Task;

public class TaskEntityManagerImpl
extends AbstractEntityManager<TaskEntity>
implements TaskEntityManager {
    @Override
    public Class<TaskEntity> getManagedEntity() {
        return TaskEntity.class;
    }

    @Override
    public TaskEntity create(Date createTime) {
        TaskEntity task = new TaskEntity();
        task.isIdentityLinksInitialized = true;
        task.createTime = createTime;
        return task;
    }

    @Override
    public TaskEntity createAndInsert(DelegateExecution execution) {
        TaskEntity task = this.create(this.getClock().getCurrentTime());
        this.insert(task, (ExecutionEntity)execution);
        return task;
    }

    @Override
    public void insert(TaskEntity entity, boolean fireCreateEvent) {
        super.insert(entity, fireCreateEvent);
        this.getHistoryManager().recordTaskId(entity);
    }

    @Override
    public void insert(TaskEntity taskEntity, ExecutionEntity execution) {
        if (execution != null && execution.getTenantId() != null) {
            taskEntity.setTenantId(execution.getTenantId());
        }
        if (execution != null) {
            execution.getTasks().add(taskEntity);
            taskEntity.setExecutionId(execution.getId());
            taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
            taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
            this.getHistoryManager().recordTaskExecutionIdChange(taskEntity.getId(), taskEntity.getExecutionId());
        }
        super.insert(taskEntity, true);
        this.getHistoryManager().recordTaskCreated(taskEntity, execution);
    }

    @Override
    public void update(TaskEntity taskEntity) {
        taskEntity.setOwner(taskEntity.getOwner());
        taskEntity.setAssignee(taskEntity.getAssignee(), true, false);
        taskEntity.setDelegationState(taskEntity.getDelegationState());
        taskEntity.setName(taskEntity.getName());
        taskEntity.setDescription(taskEntity.getDescription());
        taskEntity.setPriority(taskEntity.getPriority());
        taskEntity.setCategory(taskEntity.getCategory());
        taskEntity.setCreateTime(taskEntity.getCreateTime());
        taskEntity.setDueDate(taskEntity.getDueDate());
        taskEntity.setParentTaskId(taskEntity.getParentTaskId());
        taskEntity.setFormKey(taskEntity.getFormKey());
        this.getDbSqlSession().update(taskEntity);
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, taskEntity));
        }
    }

    @Override
    public void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade) {
        List tasks = this.getDbSqlSession().createTaskQuery().processInstanceId(processInstanceId).list();
        String reason = deleteReason == null || deleteReason.length() == 0 ? "deleted" : deleteReason;
        for (TaskEntity task : tasks) {
            if (this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(task.getExecution().getActivityId(), task.getName(), task.getExecutionId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), "userTask", UserTaskActivityBehavior.class.getName(), deleteReason));
            }
            this.deleteTask(task, reason, cascade, false);
        }
    }

    @Override
    public void deleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean cancel) {
        if (!task.isDeleted()) {
            task.fireEvent("delete");
            task.setDeleted(true);
            String taskId = task.getId();
            List<Task> subTasks = this.findTasksByParentTaskId(taskId);
            for (Task subTask : subTasks) {
                this.deleteTask((TaskEntity)subTask, deleteReason, cascade, cancel);
            }
            this.getIdentityLinkEntityManager().deleteIdentityLinksByTaskId(taskId);
            this.getVariableInstanceEntityManager().deleteVariableInstanceByTask(task);
            if (cascade) {
                this.getHistoricTaskInstanceEntityManager().delete(taskId);
            } else {
                this.getHistoryManager().recordTaskEnd(taskId, deleteReason);
            }
            this.getDbSqlSession().delete(task);
            if (this.getEventDispatcher().isEnabled()) {
                if (cancel) {
                    this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createActivityCancelledEvent(task.getExecution().getActivityId(), task.getName(), task.getExecutionId(), task.getProcessInstanceId(), task.getProcessDefinitionId(), "userTask", UserTaskActivityBehavior.class.getName(), deleteReason));
                }
                this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, task));
            }
        }
    }

    @Override
    public List<TaskEntity> findTasksByExecutionId(final String executionId) {
        return this.getList("selectTasksByExecutionId", executionId, new CachedEntityMatcher<TaskEntity>(){

            @Override
            public boolean isRetained(TaskEntity taskEntity) {
                return taskEntity.getExecutionId() != null && executionId.equals(taskEntity.getExecutionId());
            }
        }, true);
    }

    @Override
    public List<TaskEntity> findTasksByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectTasksByProcessInstanceId", processInstanceId);
    }

    @Override
    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTaskByQueryCriteria";
        return this.getDbSqlSession().selectList("selectTaskByQueryCriteria", taskQuery);
    }

    @Override
    public List<Task> findTasksAndVariablesByQueryCriteria(TaskQueryImpl taskQuery) {
        String query = "selectTaskWithVariablesByQueryCriteria";
        if (taskQuery.getFirstResult() < 0 || taskQuery.getMaxResults() <= 0) {
            return Collections.EMPTY_LIST;
        }
        int firstResult = taskQuery.getFirstResult();
        int maxResults = taskQuery.getMaxResults();
        taskQuery.setMaxResults(20000);
        taskQuery.setFirstResult(0);
        List instanceList = this.getDbSqlSession().selectListWithRawParameterWithoutFilter("selectTaskWithVariablesByQueryCriteria", taskQuery, taskQuery.getFirstResult(), taskQuery.getMaxResults());
        if (instanceList != null && !instanceList.isEmpty()) {
            if (firstResult > 0) {
                if (firstResult <= instanceList.size()) {
                    int toIndex = firstResult + Math.min(maxResults, instanceList.size() - firstResult);
                    return instanceList.subList(firstResult, toIndex);
                }
                return Collections.EMPTY_LIST;
            }
            int toIndex = Math.min(maxResults, instanceList.size());
            return instanceList.subList(0, toIndex);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByQueryCriteria", taskQuery);
    }

    @Override
    public List<Task> findTasksByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectTaskByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findTaskCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByNativeQuery", parameterMap);
    }

    @Override
    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.getDbSqlSession().selectList("selectTasksByParentTaskId", parentTaskId);
    }

    @Override
    public void deleteTask(String taskId, String deleteReason, boolean cascade) {
        TaskEntity task = (TaskEntity)this.getTaskEntityManager().findById(taskId);
        if (task != null) {
            if (task.getExecutionId() != null) {
                throw new ActivitiException("The task cannot be deleted because is part of a running process");
            }
            if (Activiti5Util.isActiviti5ProcessDefinitionId(this.getCommandContext(), task.getProcessDefinitionId())) {
                Activiti5CompatibilityHandler activiti5CompatibilityHandler = Activiti5Util.getActiviti5CompatibilityHandler();
                activiti5CompatibilityHandler.deleteTask(taskId, deleteReason, cascade);
                return;
            }
            String reason = deleteReason == null || deleteReason.length() == 0 ? "deleted" : deleteReason;
            this.deleteTask(task, reason, cascade, false);
        } else if (cascade) {
            this.getHistoricTaskInstanceEntityManager().delete(taskId);
        }
    }

    @Override
    public void updateTaskTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().update("updateTaskTenantIdForDeployment", params);
    }
}

