/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.Picture;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.db.Entity;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.IdentityInfoEntity;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.activiti.engine.impl.persistence.entity.UserEntityManager;

public class UserEntityManagerImpl
extends AbstractEntityManager<UserEntity>
implements UserEntityManager {
    @Override
    public Class<UserEntity> getManagedEntity() {
        return UserEntity.class;
    }

    @Override
    public User createNewUser(String userId) {
        return new UserEntity(userId);
    }

    @Override
    public void updateUser(User updatedUser) {
        this.getDbSqlSession().update((Entity)((Object)updatedUser));
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_UPDATED, updatedUser));
        }
    }

    @Override
    public void delete(UserEntity userEntity) {
        super.delete(userEntity);
        this.deletePicture(userEntity);
    }

    @Override
    public void deletePicture(User user) {
        UserEntity userEntity = (UserEntity)user;
        if (userEntity.getPictureByteArrayRef() != null) {
            userEntity.getPictureByteArrayRef().delete();
        }
    }

    @Override
    public void delete(String userId) {
        UserEntity user = (UserEntity)this.findById(userId);
        if (user != null) {
            List identityInfos = this.getDbSqlSession().selectList("selectIdentityInfoByUserId", userId);
            for (IdentityInfoEntity identityInfo : identityInfos) {
                this.getIdentityInfoEntityManager().delete(identityInfo);
            }
            this.getDbSqlSession().delete("deleteMembershipsByUserId", userId);
            this.delete(user);
        }
    }

    @Override
    public List<User> findUserByQueryCriteria(UserQueryImpl query, Page page) {
        return this.getDbSqlSession().selectList("selectUserByQueryCriteria", query, page);
    }

    @Override
    public long findUserCountByQueryCriteria(UserQueryImpl query) {
        return (Long)this.getDbSqlSession().selectOne("selectUserCountByQueryCriteria", query);
    }

    @Override
    public List<Group> findGroupsByUser(String userId) {
        return this.getDbSqlSession().selectList("selectGroupsByUserId", userId);
    }

    @Override
    public UserQuery createNewUserQuery() {
        return new UserQueryImpl(this.getCommandExecutor());
    }

    @Override
    public IdentityInfoEntity findUserInfoByUserIdAndKey(String userId, String key) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("key", key);
        return (IdentityInfoEntity)this.getDbSqlSession().selectOne("selectIdentityInfoByUserIdAndKey", parameters);
    }

    @Override
    public List<String> findUserInfoKeysByUserIdAndType(String userId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("userId", userId);
        parameters.put("type", type);
        return this.getDbSqlSession().getSqlSession().selectList("selectIdentityInfoKeysByUserIdAndType", parameters);
    }

    @Override
    public Boolean checkPassword(String userId, String password) {
        User user = null;
        if (userId != null) {
            user = (User)this.findById(userId);
        }
        if (user != null && password != null && password.equals(user.getPassword())) {
            return true;
        }
        return false;
    }

    @Override
    public List<User> findPotentialStarterUsers(String proceDefId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("procDefId", proceDefId);
        return (List)this.getDbSqlSession().selectOne("selectUserByQueryCriteria", parameters);
    }

    @Override
    public List<User> findUsersByNativeQuery(Map<String, Object> parameterMap, int firstResult, int maxResults) {
        return this.getDbSqlSession().selectListWithRawParameter("selectUserByNativeQuery", parameterMap, firstResult, maxResults);
    }

    @Override
    public long findUserCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectUserCountByNativeQuery", parameterMap);
    }

    @Override
    public boolean isNewUser(User user) {
        return ((UserEntity)user).getRevision() == 0;
    }

    @Override
    public Picture getUserPicture(String userId) {
        UserEntity user = (UserEntity)this.findById(userId);
        return user.getPicture();
    }

    @Override
    public void setUserPicture(String userId, Picture picture) {
        UserEntity user = (UserEntity)this.findById(userId);
        if (user == null) {
            throw new ActivitiObjectNotFoundException("user " + userId + " doesn't exist", User.class);
        }
        user.setPicture(picture);
    }
}

