/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.persistence.CachedEntityMatcher;
import org.activiti.engine.impl.persistence.entity.AbstractEntityManager;
import org.activiti.engine.impl.persistence.entity.ByteArrayRef;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntityManager;
import org.activiti.engine.impl.variable.VariableType;

public class VariableInstanceEntityManagerImpl
extends AbstractEntityManager<VariableInstanceEntity>
implements VariableInstanceEntityManager {
    @Override
    public Class<VariableInstanceEntity> getManagedEntity() {
        return VariableInstanceEntity.class;
    }

    @Override
    public VariableInstanceEntity create(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = new VariableInstanceEntity();
        variableInstance.name = name;
        variableInstance.type = type;
        variableInstance.typeName = type.getTypeName();
        variableInstance.setValue(value);
        return variableInstance;
    }

    @Override
    public VariableInstanceEntity createAndInsert(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = this.create(name, type, value);
        this.insert(variableInstance);
        return variableInstance;
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectVariablesByTaskId", taskId);
    }

    @Override
    public Collection<VariableInstanceEntity> findVariableInstancesByExecutionId(final String executionId) {
        return this.getList("selectVariablesByExecutionId", executionId, new CachedEntityMatcher<VariableInstanceEntity>(){

            @Override
            public boolean isRetained(VariableInstanceEntity variableInstanceEntity) {
                return variableInstanceEntity.getExecutionId() != null && variableInstanceEntity.getExecutionId().equals(executionId);
            }
        }, true);
    }

    @Override
    public VariableInstanceEntity findVariableInstanceByExecutionAndName(String executionId, String variableName) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("executionId", executionId);
        params.put("name", variableName);
        return (VariableInstanceEntity)this.getDbSqlSession().selectOne("selectVariableInstanceByExecutionAndName", params);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByExecutionAndNames(String executionId, Collection<String> names) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("executionId", executionId);
        params.put("names", names);
        return this.getDbSqlSession().selectList("selectVariableInstancesByExecutionAndNames", params);
    }

    @Override
    public VariableInstanceEntity findVariableInstanceByTaskAndName(String taskId, String variableName) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("taskId", taskId);
        params.put("name", variableName);
        return (VariableInstanceEntity)this.getDbSqlSession().selectOne("selectVariableInstanceByTaskAndName", params);
    }

    @Override
    public List<VariableInstanceEntity> findVariableInstancesByTaskAndNames(String taskId, Collection<String> names) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("taskId", taskId);
        params.put("names", names);
        return this.getDbSqlSession().selectList("selectVariableInstancesByTaskAndNames", params);
    }

    @Override
    public void delete(VariableInstanceEntity entity) {
        this.delete(entity, true);
    }

    @Override
    public void delete(VariableInstanceEntity entity, boolean fireDeleteEvent) {
        this.getDbSqlSession().delete(entity);
        ByteArrayRef byteArrayRef = entity.getByteArrayRef();
        if (byteArrayRef != null) {
            byteArrayRef.delete();
        }
        entity.setDeleted(true);
        if (fireDeleteEvent && this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.ENTITY_DELETED, entity));
        }
    }

    @Override
    public void deleteVariableInstanceByTask(TaskEntity task) {
        Map<String, VariableInstanceEntity> variableInstances = task.getVariableInstances();
        if (variableInstances != null) {
            for (VariableInstanceEntity variableInstance : variableInstances.values()) {
                this.delete(variableInstance);
            }
        }
    }
}

