/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.test;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.jobexecutor.JobExecutor;
import org.activiti.engine.test.ActivitiRule;

public class JobTestHelper {
    public static void waitForJobExecutorToProcessAllJobs(ActivitiRule activitiRule, long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobs(activitiRule.getProcessEngine().getProcessEngineConfiguration(), activitiRule.getManagementService(), maxMillisToWait, intervalMillis);
    }

    public static void waitForJobExecutorToProcessAllJobs(ProcessEngineConfiguration processEngineConfiguration, ManagementService managementService, long maxMillisToWait, long intervalMillis) {
        JobTestHelper.waitForJobExecutorToProcessAllJobs(processEngineConfiguration, managementService, maxMillisToWait, intervalMillis, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForJobExecutorToProcessAllJobs(ProcessEngineConfiguration processEngineConfiguration, ManagementService managementService, long maxMillisToWait, long intervalMillis, boolean shutdownExecutorWhenFinished) {
        JobExecutor jobExecutor = null;
        AsyncExecutor asyncExecutor = null;
        if (!processEngineConfiguration.isAsyncExecutorEnabled()) {
            jobExecutor = processEngineConfiguration.getJobExecutor();
            jobExecutor.start();
        } else {
            asyncExecutor = processEngineConfiguration.getAsyncExecutor();
            asyncExecutor.start();
        }
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    try {
                        areJobsAvailable = JobTestHelper.areJobsAvailable(managementService);
                    }
                    catch (Throwable t) {}
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ActivitiException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            if (shutdownExecutorWhenFinished) {
                if (!processEngineConfiguration.isAsyncExecutorEnabled()) {
                    jobExecutor.shutdown();
                } else {
                    asyncExecutor.shutdown();
                }
            }
        }
    }

    public static void waitForJobExecutorOnCondition(ActivitiRule activitiRule, long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobTestHelper.waitForJobExecutorOnCondition(activitiRule.getProcessEngine().getProcessEngineConfiguration(), maxMillisToWait, intervalMillis, condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForJobExecutorOnCondition(ProcessEngineConfiguration processEngineConfiguration, long maxMillisToWait, long intervalMillis, Callable<Boolean> condition) {
        JobExecutor jobExecutor = null;
        AsyncExecutor asyncExecutor = null;
        if (!processEngineConfiguration.isAsyncExecutorEnabled()) {
            jobExecutor = processEngineConfiguration.getJobExecutor();
            jobExecutor.start();
        } else {
            asyncExecutor = processEngineConfiguration.getAsyncExecutor();
            asyncExecutor.start();
        }
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean conditionIsViolated = true;
            try {
                while (conditionIsViolated) {
                    Thread.sleep(intervalMillis);
                    conditionIsViolated = condition.call() == false;
                }
            }
            catch (InterruptedException e) {
            }
            catch (Exception e) {
                throw new ActivitiException("Exception while waiting on condition: " + e.getMessage(), e);
            }
            finally {
                timer.cancel();
            }
            if (conditionIsViolated) {
                throw new ActivitiException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            if (!processEngineConfiguration.isAsyncExecutorEnabled()) {
                jobExecutor.shutdown();
            } else {
                asyncExecutor.shutdown();
            }
        }
    }

    public static void executeJobExecutorForTime(ActivitiRule activitiRule, long maxMillisToWait, long intervalMillis) {
        JobTestHelper.executeJobExecutorForTime(activitiRule.getProcessEngine().getProcessEngineConfiguration(), maxMillisToWait, intervalMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void executeJobExecutorForTime(ProcessEngineConfiguration processEngineConfiguration, long maxMillisToWait, long intervalMillis) {
        JobExecutor jobExecutor = null;
        AsyncExecutor asyncExecutor = null;
        if (!processEngineConfiguration.isAsyncExecutorEnabled()) {
            jobExecutor = processEngineConfiguration.getJobExecutor();
            jobExecutor.start();
        } else {
            asyncExecutor = processEngineConfiguration.getAsyncExecutor();
            asyncExecutor.start();
        }
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            try {
                while (!task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                }
                timer.cancel();
                return;
            }
            catch (InterruptedException e) {
                return;
            }
            finally {
                timer.cancel();
            }
        }
        finally {
            if (!processEngineConfiguration.isAsyncExecutorEnabled()) {
                jobExecutor.shutdown();
            } else {
                asyncExecutor.shutdown();
            }
        }
    }

    public static boolean areJobsAvailable(ActivitiRule activitiRule) {
        return JobTestHelper.areJobsAvailable(activitiRule.getManagementService());
    }

    public static boolean areJobsAvailable(ManagementService managementService) {
        return !managementService.createJobQuery().list().isEmpty();
    }

    private static class InteruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded;
        protected Thread thread;

        public InteruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

