/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.compatibility.Activiti5CompatibilityHandler;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;

public class Activiti5Util {
    public static boolean isActiviti5ProcessDefinitionId(CommandContext commandContext, String processDefinitionId) {
        if (processDefinitionId == null) {
            return false;
        }
        ProcessDefinitionEntity processDefinitionEntity = ProcessDefinitionUtil.getProcessDefinitionEntity(processDefinitionId);
        if (processDefinitionEntity == null) {
            return false;
        }
        return Activiti5Util.isActiviti5ProcessDefinition(commandContext, processDefinitionEntity);
    }

    public static boolean isActiviti5ProcessDefinition(CommandContext commandContext, ProcessDefinitionEntity processDefinitionEntity) {
        if (!commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled()) {
            return false;
        }
        if (processDefinitionEntity.getEngineVersion() != null) {
            if ("activiti-5".equals(processDefinitionEntity.getEngineVersion())) {
                if (commandContext.getProcessEngineConfiguration().isActiviti5CompatibilityEnabled()) {
                    return true;
                }
            } else {
                throw new ActivitiException("Invalid 'engine' for process definition " + processDefinitionEntity.getId() + " : " + processDefinitionEntity.getEngineVersion());
            }
        }
        return false;
    }

    public static Activiti5CompatibilityHandler getActiviti5CompatibilityHandler() {
        Activiti5CompatibilityHandler activiti5CompatibilityHandler = Context.getActiviti5CompatibilityHandler();
        if (activiti5CompatibilityHandler == null) {
            activiti5CompatibilityHandler = Context.getFallbackActiviti5CompatibilityHandler();
        }
        if (activiti5CompatibilityHandler == null) {
            throw new ActivitiException("Found Activiti 5 process definition, but no compatibility handler on the classpath");
        }
        return activiti5CompatibilityHandler;
    }
}

