/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.deploy.ProcessDefinitionCacheEntry;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.util.Activiti5Util;

public class ProcessDefinitionUtil {
    public static ProcessDefinitionEntity getProcessDefinitionEntity(String processDefinitionId) {
        return ProcessDefinitionUtil.getProcessDefinitionEntity(processDefinitionId, false);
    }

    public static ProcessDefinitionEntity getProcessDefinitionEntity(String processDefinitionId, boolean checkCacheOnly) {
        if (checkCacheOnly) {
            ProcessDefinitionCacheEntry cacheEntry = Context.getProcessEngineConfiguration().getProcessDefinitionCache().get(processDefinitionId);
            if (cacheEntry != null) {
                return cacheEntry.getProcessDefinitionEntity();
            }
            return null;
        }
        return Context.getProcessEngineConfiguration().getDeploymentManager().findDeployedProcessDefinitionById(processDefinitionId);
    }

    public static Process getProcess(String processDefinitionId) {
        if (Context.getProcessEngineConfiguration() == null) {
            return Activiti5Util.getActiviti5CompatibilityHandler().getProcessDefinitionProcessObject(processDefinitionId);
        }
        DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinitionEntity processDefinitionEntity = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        return deploymentManager.resolveProcessDefinition(processDefinitionEntity).getProcess();
    }

    public static BpmnModel getBpmnModel(String processDefinitionId) {
        if (Context.getProcessEngineConfiguration() == null) {
            return Activiti5Util.getActiviti5CompatibilityHandler().getProcessDefinitionBpmnModel(processDefinitionId);
        }
        DeploymentManager deploymentManager = Context.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinitionEntity processDefinitionEntity = deploymentManager.findDeployedProcessDefinitionById(processDefinitionId);
        return deploymentManager.resolveProcessDefinition(processDefinitionEntity).getBpmnModel();
    }
}

