/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.tree;

import java.util.Iterator;
import java.util.List;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.util.tree.ExecutionTreeBfsIterator;

public class ExecutionTreeNode
implements Iterable<ExecutionTreeNode> {
    protected ExecutionEntity executionEntity;
    protected ExecutionTreeNode parent;
    protected List<ExecutionTreeNode> children;

    public ExecutionTreeNode(ExecutionEntity executionEntity) {
        this.executionEntity = executionEntity;
    }

    public ExecutionEntity getExecutionEntity() {
        return this.executionEntity;
    }

    public void setExecutionEntity(ExecutionEntity executionEntity) {
        this.executionEntity = executionEntity;
    }

    public ExecutionTreeNode getParent() {
        return this.parent;
    }

    public void setParent(ExecutionTreeNode parent) {
        this.parent = parent;
    }

    public List<ExecutionTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ExecutionTreeNode> children) {
        this.children = children;
    }

    @Override
    public Iterator<ExecutionTreeNode> iterator() {
        return new ExecutionTreeBfsIterator(this);
    }

    public ExecutionTreeBfsIterator leafsFirstIterator() {
        return new ExecutionTreeBfsIterator(this, true);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.getExecutionEntity().getId() + " : " + this.getExecutionEntity().getActivityId() + ", parent id " + this.getExecutionEntity().getParentId() + "\r\n");
        if (this.children != null) {
            for (ExecutionTreeNode childNode : this.children) {
                childNode.internalToString(strb, "", true);
            }
        }
        return strb.toString();
    }

    protected void internalToString(StringBuilder strb, String prefix, boolean isTail) {
        strb.append(prefix + (isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ") + this.getExecutionEntity().getId() + " : " + this.getExecutionEntity().getActivityId() + ", parent id " + this.getExecutionEntity().getParentId() + (this.getExecutionEntity().isScope() ? " (scope)" : "") + "\r\n");
        if (this.children != null) {
            for (int i = 0; i < this.children.size() - 1; ++i) {
                this.children.get(i).internalToString(strb, prefix + (isTail ? "    " : "\u2502   "), false);
            }
            if (this.children.size() > 0) {
                this.children.get(this.children.size() - 1).internalToString(strb, prefix + (isTail ? "    " : "\u2502   "), true);
            }
        }
    }
}

