/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test.impl.logger;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class DebugInfoExecutionTree {
    protected DebugInfoExecutionTreeNode processInstance;

    public DebugInfoExecutionTreeNode getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(DebugInfoExecutionTreeNode processInstance) {
        this.processInstance = processInstance;
    }

    public static class DebugInfoExecutionTreeNode {
        protected String id;
        protected String processDefinitionId;
        protected String activityId;
        protected String activityName;
        protected DebugInfoExecutionTreeNode parentNode;
        protected List<DebugInfoExecutionTreeNode> childNodes = new ArrayList<DebugInfoExecutionTreeNode>();

        public void print(Logger logger) {
            logger.info("");
            logger.info(this.id);
            for (DebugInfoExecutionTreeNode childNode : this.childNodes) {
                childNode.print(logger, "", true);
            }
            logger.info("");
        }

        protected void print(Logger logger, String prefix, boolean isTail) {
            logger.info(prefix + (isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ") + this.getCurrentFlowElementInfo());
            for (int i = 0; i < this.childNodes.size() - 1; ++i) {
                this.childNodes.get(i).print(logger, prefix + (isTail ? "    " : "\u2502   "), false);
            }
            if (this.childNodes.size() > 0) {
                this.childNodes.get(this.childNodes.size() - 1).print(logger, prefix + (isTail ? "    " : "\u2502   "), true);
            }
        }

        protected String getCurrentFlowElementInfo() {
            StringBuilder strb = new StringBuilder();
            strb.append(this.id);
            if (this.activityId != null || this.activityName != null) {
                strb.append(" in flow element ");
                if (this.activityId != null) {
                    strb.append("'" + this.activityId + "'");
                }
                if (this.activityName != null) {
                    strb.append(" with name " + this.activityName);
                }
            }
            return strb.toString();
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getProcessDefinitionId() {
            return this.processDefinitionId;
        }

        public void setProcessDefinitionId(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }

        public String getActivityId() {
            return this.activityId;
        }

        public void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public String getActivityName() {
            return this.activityName;
        }

        public void setActivityName(String activityName) {
            this.activityName = activityName;
        }

        public DebugInfoExecutionTreeNode getParentNode() {
            return this.parentNode;
        }

        public void setParentNode(DebugInfoExecutionTreeNode parentNode) {
            this.parentNode = parentNode;
        }

        public List<DebugInfoExecutionTreeNode> getChildNodes() {
            return this.childNodes;
        }

        public void setChildNodes(List<DebugInfoExecutionTreeNode> childNodes) {
            this.childNodes = childNodes;
        }
    }
}

