/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test.impl.logger;

import java.sql.Date;
import java.text.SimpleDateFormat;
import org.activiti.engine.impl.agenda.AbstractOperation;
import org.activiti.engine.test.impl.logger.AbstractDebugInfo;
import org.activiti.engine.test.impl.logger.DebugInfoExecutionTree;
import org.slf4j.Logger;

public class DebugInfoOperationExecuted
extends AbstractDebugInfo {
    protected long preExecutionTime;
    protected long postExecutionTime;
    protected AbstractOperation operation;
    protected String executionId;
    protected String flowElementId;
    protected Class<?> flowElementClass;
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");

    public DebugInfoOperationExecuted(AbstractOperation operation) {
        this.operation = operation;
        if (operation.getExecution() != null) {
            this.executionId = operation.getExecution().getId();
            if (operation.getExecution().getCurrentFlowElement() != null) {
                this.flowElementId = operation.getExecution().getCurrentFlowElement().getId();
                this.flowElementClass = operation.getExecution().getCurrentFlowElement().getClass();
            }
        }
    }

    @Override
    public void printOut(Logger logger) {
        this.printOperationInfo(logger);
        if (this.getExecutionTrees().size() > 0) {
            for (DebugInfoExecutionTree executionTree : this.getExecutionTrees()) {
                executionTree.getProcessInstance().print(logger);
            }
        }
    }

    protected void printOperationInfo(Logger logger) {
        StringBuilder strb = new StringBuilder();
        strb.append("[" + this.dateFormat.format(new Date(this.getPreExecutionTime())) + " - " + this.dateFormat.format(new Date(this.getPostExecutionTime())) + " (" + (this.getPostExecutionTime() - this.getPreExecutionTime()) + "ms)]");
        strb.append(" " + this.getOperation().getClass().getSimpleName() + " ");
        if (this.getExecutionId() != null) {
            strb.append("with execution " + this.getExecutionId());
            if (this.getFlowElementId() != null) {
                strb.append(" at flow element " + this.getFlowElementId() + " (" + this.getFlowElementClass().getSimpleName() + ")");
            }
        }
        logger.info(strb.toString());
    }

    public long getPreExecutionTime() {
        return this.preExecutionTime;
    }

    public void setPreExecutionTime(long preExecutionTime) {
        this.preExecutionTime = preExecutionTime;
    }

    public long getPostExecutionTime() {
        return this.postExecutionTime;
    }

    public void setPostExecutionTime(long postExecutionTime) {
        this.postExecutionTime = postExecutionTime;
    }

    public AbstractOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AbstractOperation operation) {
        this.operation = operation;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public String getFlowElementId() {
        return this.flowElementId;
    }

    public void setFlowElementId(String flowElementId) {
        this.flowElementId = flowElementId;
    }

    public Class<?> getFlowElementClass() {
        return this.flowElementClass;
    }

    public void setFlowElementClass(Class<?> flowElementClass) {
        this.flowElementClass = flowElementClass;
    }
}

